# <cfzipparam>

The cfzipparam tag is always a child tag of the cfzip tag. See tag [<cfzip>](zip.md) for more details.

This tag **cannot** have a body.
This tag is also supported within [<cfscript>](script.md)

**Requires Extension:** [Compress Tags for Jakarta EE (Lucee 7+)](https://download.lucee.org/#8D7FB0DF-08BB-1589-FE3975678F07DB17)

```
<cfzipparam
    charset=string
    content=any
    entryPath=string
    filter=any
    filterDelimiters=string
    prefix=string
    source=string
    recurse=boolean
    password=string
    encryptionalgorithm=string
>
```

# Attributes

| Attribute | Type | Required | Description | Default |
|-----------|------|----------|-------------|---------|
| charset | string | No | Converts string content into binary data before putting it into a ZIP or JAR file. Used only when cfzip action="zip" and the cfzipparam content is a string. Examples of character sets are: - JIS - RFC1345 - UTF-16 (optional, default=encoding of the host machine) |  |
| content | any | No | Content written to the ZIP or JAR entry. Used only when cfzip action="zip". Valid content data types are binary and string. If you specify the content attribute, you must specify the entrypath attribute. |  |
| entryPath | string | No | Pathname used: - For cfzip action="zip", it is the entrypath used. This is valid only when the source is a file. The entrypath creates a subdirectory within the ZIP or JAR file. - For cfzip action="unzip", it is the pathname to unzip. - For cfzip action="delete", it is the pathname to delete from the ZIP or JAR file. |  |
| filter | any | No | Optional filter. Can be either a wildcard filter, e.g. "m*", or a UDF/Closure which accepts the file/directory name and returns a boolean value to indicate whether that item should be included in the result or not. |  |
| filterDelimiters | string | No | Optional when passing a filter pattern. This value is used as a delimiter for the patterns. Default is the pipe "\|" character. |  |
| prefix | string | No | String added as a prefix to the ZIP or JAR entry. Used only when cfzip action="zip". |  |
| source | string | No | Source directory or file. Used only when cfzip action="zip". Specified file(s) are added to the ZIP or JAR file: - If you specify source attribute for the cfzip tag, the cfzipparam source is relative to it. - If you do not specify a source attribute for the cfzip tag, the cfzipparam source must be an absolute path. |  |
| recurse | boolean | No | Recurse the directory to be zipped, unzipped, or deleted, as specified by the cfzip parent tag. (optional, default=yes) |  |
| password | string | No | Password for the file(s) added via cfzipparam |  |
| encryptionalgorithm | string | No | Supported algorithms are: - aes(=aes256) - aes128 - standard |  |

# Examples

*There are currently no examples for this tag.*








# Categories

[Zip files](../../categories/zip.md)

# See Also

[<cfzip>](zip.md)