# <cfzip>

Manipulates ZIP and Java Archive (JAR) files.

In addition to the basic zip and unzip functions, use the cfzip tag supports

- deleting entries from an archive
- filter files
- read files in binary format
- list the contents of an archive
- specify an entry path used in an executable JAR file.

This tag **may** have a body.
This tag is also supported within [<cfscript>](script.md)

**Requires Extension:** [Compress Tags for Jakarta EE (Lucee 7+)](https://download.lucee.org/#8D7FB0DF-08BB-1589-FE3975678F07DB17)

```
<cfzip
    action=delete|list|read|readbinary|unzip|zip
    password=string
    charset=string
    destination=string
    entryPath=string
    file=string
    filter=any
    filterDelimiters=string
    name=string
    overwrite=boolean
    prefix=string
    recurse=boolean
    showDirectory=boolean
    source=string
    storePath=boolean
    variable=string
    encryptionalgorithm=string
    compressionMethod=string
><!--- body ---></cfzip>
```

# Attributes

| Attribute | Type | Required | Description | Default |
|-----------|------|----------|-------------|---------|
| action | string | No | The action to take. - delete - list - read - readbinary - unzip - zip | zip |
| password | string | No | Password for the zip file. |  |
| charset | string | No | The character set used to translate the ZIP or JAR entry into a text string. Examples of character sets are: - JIS - RFC1345 - UTF-16 (optional, default=encoding of the host machine) |  |
| destination | string | No | Destination directory where the ZIP or JAR file is extracted. |  |
| entryPath | string | No | Pathname on which the action is performed. |  |
| file | string | No | Absolute pathname of the file on which the action is performed. For example, the full pathname of the ZIP file: c:\temp\log.zip. |  |
| filter | any | No | Optional filter. - Can be either a wildcard filter, e.g. "m*" - or a UDF/Closure which is passed each `file/directory` path and returns a **boolean value** to indicate whether that item should be included in the result or not. `function ( entryPath ){ return true \| false }` |  |
| filterDelimiters | string | No | Optional when passing a filter pattern. This value is used as a delimiter for the patterns. Default is the pipe "\|" character. |  |
| name | string | No | Record set name in which the result of the list action is stored. The record set columns are: - name: filename of the entry in the JAR file. For example, if the entry is help/docs/index.htm, the name is index.htm. - directory: directory containing the entry. For the example above, the directory is help/docs. You can obtain the full entry name by concatenating directory and name. If an entry is at the root level, the directory is empty (''). - size: uncompressed size of the entry, in bytes. - compressedSize: compressed size of the entry, in bytes. - type: type of entry (directory or file). - dateLastModified: last modified date of the entry, cfdate object. - comment: any comment, if present, for the entry. - crc: crc-32 checksum of the uncompressed entry data. |  |
| overwrite | boolean | No | unzip: Specifies whether to overwrite the extracted files: - yes: if the extracted file already exists at the destination specified, the file is overwritten. - no: if the extracted file already exists at the destination specified, the file is not overwritten and that entry is not extracted. The remaining entries are extracted. zip: Specifies whether to overwrite the contents of a ZIP or JAR file: - yes: overwrites all of the content in the ZIP or JAR file if it exists. - no: updates existing entries and adds new entries to the ZIP or JAR file if it exists. (optional, default=no) |  |
| prefix | string | No | String added as a prefix to the ZIP or JAR entry. The string is the name of a subdirectory in which the entries are added. |  |
| recurse | boolean | No | Specifies whether the action applies to subdirectories: - yes: includes subdirectories. - no: does not include subdirectories. (optional, default=yes) |  |
| showDirectory | boolean | No | yes: lists the directories. no: does not list directories. (optional, default= no) |  |
| source | string | No | Source directory to be zipped. Not required if cfzipparam is specified. |  |
| storePath | boolean | No | zip: Specifies whether pathnames are stored in the ZIP or JAR file: - yes: pathnames of entries are stored in the ZIP or JAR file. - no: pathnames of the entries are not stored in the ZIP or JAR file. All the files are placed at the root level. In case of a name conflict, the last file in the iteration is added. unzip: Specifies whether files are stored at the entrypath: - yes: the files are extracted to the entrypath. - no: the entrypath is ignored and all the files are extracted at the root level. (optional, default= yes) |  |
| variable | string | No | Variable in which the read content is stored. |  |
| encryptionalgorithm | string | No | Supported algorithms are: - aes(=aes256) - aes128 - standard |  |
| compressionMethod | string | No | Set the zip compression level - deflate, deflateNormal (default) - deflateFast - deflateFastest - deflateMaximum - deflateUtra - store (no compression, good for images) |  |

# Examples

### Simple format for cfzip

### Action unzip

```cfml
<cfzip action="unzip" destination="#gettempdirectory()#" file="zippath">
```

### Action delete

```cfml
<cfzip action="delete" file="#expandpath('./list.zip')#" entrypath="list/hai">
```

### Action zip

```cfml
<cfzip action="zip" source="#expandpath('./ziptest.txt')#" file="#expandpath("'./zip/')#">
```

### Action list

```cfml
<cfzip action="list" file="#expandpath('./list.zip')#" name="res">
```








# Categories

[Zip files](../../categories/zip.md)

# See Also

[Compress()](../functions/compress.md), [Extract()](../functions/extract.md), [IsZipFile()](../functions/iszipfile.md), [<cfzipparam>](zipparam.md)