# <cfxml>

Creates a CFML XML document object that contains the markup in the tag body.

This tag can include XML and CFML tags.

Lucee processes the CFML code in the tag body, then assigns the resulting text to an XML document object variable.

This tag **must** have a body.
This tag is also supported within [<cfscript>](script.md)

```
<cfxml
    variable=string
    caseSensitive=boolean
    validator=string
    lenient=boolean
><!--- body ---></cfxml>
```

# Attributes

| Attribute | Type | Required | Description | Default |
|-----------|------|----------|-------------|---------|
| variable | string | Yes | name of an XML variable |  |
| caseSensitive | boolean | No | if set to true maintains the case of document elements and attributes |  |
| validator | string | No | Any of the following: - A string containing a DTD or Schema - The name of a DTD or Schema file - The URL of a DTD or Schema file; valid protocol identifiers include http, https, ftp, and file |  |
| lenient | boolean | No | if set to true, the parser is more lenient and forgives invalid XML and does the best to interpret it. |  |

# Examples

```cfml
 <cfxml variable="xmlobject">
	<office>
		<employee>
			<emp_name>lucee_dev</emp_name>
			<emp_no>121</emp_no>
		</employee>
	</office>
</cfxml>
<cfdump var="#xmlobject#" />
```






