# <cfwhile>

Simplification of the tag cfloop-condition, analog to the cfscript "while" loop.

This tag **must** have a body.
This tag is also supported within [<cfscript>](script.md)

```
<cfwhile
    condition=boolean
    label=string
><!--- body ---></cfwhile>
```

# Attributes

| Attribute | Type | Required | Description | Default |
|-----------|------|----------|-------------|---------|
| condition | boolean | No | condition o the expression |  |
| label | string | No | used to address this loop from a "break" or "continue" statement (instead of the nearest one). |  |

# Examples

```cfml
testCondition = true;
cnt = 0;
while(testCondition) {
    cnt = cnt + 1;
    if (cnt EQ 5) {
        testCondition = false;
    }
}
echo(cnt);
```

```cfml
<!--- testing condition  --->
<cfset testCondition = true>
<cfset cnt = 0>
<cfloop condition="#testCondition#">
    <cfset cnt = cnt + 1>
    <cfif cnt EQ 5>
        <cfset testCondition = false>
    </cfif>
</cfloop>
<cfoutput>#cnt#</cfoutput>
```

```cfml
// breaking out using a label
x = 0;
WhileLabel: while (x < 10){
    writeOutput("x is #x#<br>");
    switch (x){
        case 1:
            break;
        case 3:
            break WhileLabel;
    }
    x++;
    writeOutput("end of loop<br>");
}
writeOutput("After loop, x is #x#<br>");
```

```cfml
<!--- breaking out using a label ---> 
<cfset x = 0>
<cfloop condition="x LT 10" index="i" label="WhileLabel">
    <cfoutput>x is #x#<br></cfoutput>
    <cfswitch expression="#x#">
        <cfcase value="1">
            <cfbreak>
        </cfcase>
        <cfcase value="3">
            <cfbreak loop="WhileLabel">
        </cfcase>
    </cfswitch>
    <cfset x = x + 1>
    <cfoutput>end of loop<br></cfoutput>
</cfloop>
<cfoutput>After loop, x is #x#<br></cfoutput>
```








# See Also

[<cfbreak>](break.md), [<cfloop>](loop.md)