# <cfwddx>

Serializes and de-serializes CFML data structures to the XML-based WDDX format.

Generates JavaScript statements to instantiate JavaScript objects equivalent to the contents of a WDDX packet or some CFML data structures.

This tag **cannot** have a body.
This tag is also supported within [<cfscript>](script.md)

```
<cfwddx
    action=cfml2wddx|wddx2cfml|cfml2js|wddx2js
    input=any
    output=string
    topLevelVariable=string
    useTimeZoneInfo=boolean
    validate=boolean
    xmlConform=boolean
>
```

# Attributes

| Attribute | Type | Required | Description | Default |
|-----------|------|----------|-------------|---------|
| action | string | Yes | Specifies the action taken by the cfwddx tag. - cfml2wddx - wddx2cfml - cfml2js - wddx2js |  |
| input | any | Yes | The value to be processed. |  |
| output | string | No | The name of the variable to hold the output of the operation. This attribute is required for action = 'WDDX2CFML'. For all other actions, if this attribute is not provided, the result of the WDDX processing is outputted in the HTML stream. |  |
| topLevelVariable | string | No | The name of the top-level JavaScript object created by the deserialization process. The object created is an instance of the WddxRecordset object, explained in WddxRecordset Object. |  |
| useTimeZoneInfo | boolean | No | Indicates whether to output time-zone information when serializing CFML to WDDX. If time-zone information is taken into account, the hour-minute offset, as represented in the ISO8601 format, is calculated in the date-time output. If time-zone information is not taken into account, the local time is output. The default is Yes. |  |
| validate | boolean | No | Applies if action = "wddx2cfml" or "wddx2js". - Yes: validates WDDX input with an XML parser using WDDX DTD. If parser processes input without error, packet is deserialized. Otherwise, an error is thrown. - No: no input validation |  |
| xmlConform | boolean | No | if set to true generate valid XML, if set to false (default) the XML generated is compatible to other engines, but not valid XML (use for example single quotes for attribute values) |  |

# Examples

### Simple Example with tag format

```cfml
<cfset qry = queryNew("id,test","integer,varchar",[{id:1,test:"test"},{id:2,test:"name"}])>
<cfdump var="#qry#" label="Query">

<cfwddx action="cfml2wddx" input="#qry#" output="WDDX_qry">
<cfdump var="#WDDX_qry#" label="action=cfml2wddx">

<cfwddx action="wddx2cfml" input="#WDDX_qry#" output="CFML_qry">
<cfdump var="#CFML_qry#" label="action=wddx2cfml">

<cfwddx action="cfml2js" topLevelVariable="CFML_js" input="#qry#" output="CFML_js">
<cfdump var="#CFML_js#" label="action=cfml2js">

<cfwddx action="wddx2js" topLevelVariable="test" input="#WDDX_qry#" output="WDDX_js">
<cfdump var="#WDDX_js#" label="action=wddx2js">

```

### Simple Example with script format

```cfml
	// This WDDX packet contains a struct with 4 keys: 3 strings and 1 array of numbers
	strWDDX = "<wddxPacket version='1.0'><header/><data><struct><var name='VERSION'><string>1.0.0</string></var><var name='COUNTDOWNARRAY'><array length='5'><number>5.0</number><number>4.0</number><number>3.0</number><number>2.0</number><number>1.0</number></array></var><var name='NAME'><string>Test Struct</string></var><var name='DESCRIPTION'><string>To illustrate serializing to WDDX</string></var></struct></data></wddxPacket>";

	wddx action='wddx2cfml' input=strWDDX output='example';

	dump(example);

```








# Categories

[WDDX](../../categories/wddx.md)

# See Also

[DeserializeJSON()](../functions/deserializejson.md), [IsWddx()](../functions/iswddx.md), [SerializeJSON()](../functions/serializejson.md)