# <cftry>

Used with one or more [<cfcatch>](catch.md) tags, the cftry tag lets you catch and process exceptions in CFML pages.

Exceptions include events that disrupt the normal flow of instructions in a CFML page, such as failed database operations, missing include files, and developer-specified events.

This tag **must** have a body.
This tag is also supported within [<cfscript>](script.md)

```
<cftry><!--- body ---></cftry>
```

*This tag does not use any attributes.*

# Examples

### Tag example

```cfml

<cftry>
  <cfquery name="getCountofReminders" datasource="dsn">
    select count(id) from reminders where id = <cfqueryparam value="#arguments.id#" cfsqltype="cf_sql_number">
  </cfquery>
  <cfcatch type="database">
    <cfoutput>
      <p>There was a problem getting a count of your reminders)</p>
    </cfoutput>
    <cfdump var=#cfcatch#>
  </cfcatch>
</cftry>

```

### Script example

```cfml
 try {
	a = 2/0
        writeDump("#a#");
      }
catch(any e){
	writeOutput("Caught an error.");
      }
```

### Adding additional info to an Exception

```cfml
    try {
        try {
            throw message="test exception";
        } catch (any e) {
            // throw original exception with additional info, using "cause" Lucee 6+
            // see the "Caused by" at the bottom of the java stacktrace
            throw(message="error running batch", cause=e); 
        }
    } catch (ee){
        // this extra catch is to prevent trycf swallowing the exception detail
        echo(ee); 
    }
```








# Categories

[Core CFML Language](../../categories/core.md)

# See Also

[Exception Output](../../recipes/exception-output.md), [Retry](../../recipes/retry.md), [<cfcatch>](catch.md), [<cffinally>](finally.md), [<cfrethrow>](rethrow.md), [<cfretry>](retry.md), [<cfthrow>](throw.md)