# <cftransaction>

Groups multiple queries into a single unit. 

The cftransaction tag provides commit and rollback processing.

This tag **must** have a body.
This tag is also supported within [<cfscript>](script.md)

```
<cftransaction
    action=begin|commit|setSavePoint|rollback
    isolation=string
><!--- body ---></cftransaction>
```

# Attributes

| Attribute | Type | Required | Description | Default |
|-----------|------|----------|-------------|---------|
| action | string | No | - begin: The start of the block of code to execute. - commit: Commits a pending transaction. - rollback: Rolls back a pending transaction. - setsavepoint: Saves a specific state within a transaction |  |
| isolation | string | No | Database lock type. - read_uncommitted - read_committed - repeatable_read - serializable - none <https://en.wikipedia.org/wiki/Isolation_(database_systems)> |  |

# Examples

```cfml

<cffunction name="updateAddress" access="remote" output="false">
  <cfargument name="addressId" type="number" required="yes">
  <cfargument name="newAddress" type="string" required="yes">

  <cftransaction isolation="read_committed">
   	 <cfquery name="changeAddress" datasource="#application.config.DSN#">
  		update address
		set login_address = <cfqueryparam value="#arguments.newAddress#" cfsqltype="VARCHAR">
		where	id = <cfqueryparam value="#arguments.addressId#" cfsqltype="INTEGER">
	    </cfquery>
  </cftransaction>
</cffunction>
```








# Categories

[ORM](../../categories/orm.md), [Queries](../../categories/query.md)

# See Also

[IsWithinTransaction()](../functions/iswithintransaction.md), [TransactionCommit()](../functions/transactioncommit.md), [TransactionRollback()](../functions/transactionrollback.md), [TransactionSetSavePoint()](../functions/transactionsetsavepoint.md)