# <cftrace>

Displays and logs debugging data about the state of an application at the time the cftrace tag executes.

This tag **may** have a body.
This tag is also supported within [<cfscript>](script.md)

```
<cftrace
    abort=boolean
    category=string
    inline=boolean
    text=string
    type=string
    var=string
    follow=boolean
><!--- body ---></cftrace>
```

# Attributes

| Attribute | Type | Required | Description | Default |
|-----------|------|----------|-------------|---------|
| abort | boolean | No | Calls cfabort tag when the tag is executed |  |
| category | string | No | User-defined string for identifying trace groups |  |
| inline | boolean | No | Displays trace code in line on the page in the location of the cftrace tag, addition to the debugging information output. |  |
| text | string | No | User-defined string, which can include simple variable, but not complex variables such as arrays. Outputs to cflog text attribute |  |
| type | string | No | Corresponds to the cflog type attribute; displays an appropriate icon. - Information - Warning - Error - Fatal |  |
| var | string | No | The name of a simple or complex variable to display. Useful for displaying a temporary value, or a value that does not display on any CFM page. *Alias: variable* |  |
| follow | boolean | No | If true, Lucee follows the object defined in the [var] attribute and will log any changes to it. Ignored when attribute [var] is not defined. |  |

# Examples

*There are currently no examples for this tag.*








# Categories

[Debugging](../../categories/debugging.md)

# See Also

[Trace()](../functions/trace.md)