# <cftimer>

Displays execution time for a specified section of CFML code.

Lucee displays the timing information along with any output produced by the timed code.

This tag **must** have a body.
This tag is also supported within [<cfscript>](script.md)

```
<cftimer
    type=string
    label=string
    unit=string
    variable=string
><!--- body ---></cftimer>
```

# Attributes

| Attribute | Type | Required | Description | Default |
|-----------|------|----------|-------------|---------|
| type | string | No | - debug: displays timing information in a table in the debug output under the heading "CFTimer Times". There is a column for Label, Time (in ms), and Template. The default label is an empty string. - comment: displays timing information as an inline HTML comment following the closing `</cftimer>`. Uses the format `<!-- [label]: [elapsed time in ms] -->`. The default label is an empty string. - inline: displays timing information as inline HTML following the closing `</cftimer>`. Uses the format `[label]: [elapsed time in ms]`. The default label is an empty string. - outline: wraps the `<cftimer>` block with a `<fieldset>` element, then displays timing information as a `<legend>` element rendered just before the closing `</fieldset>`. Uses the format `<legend align="top">[label]: [elapsed time in ms]</legend>`. The `<fieldset>` element is given a class of `cftimer`. The default label is an empty string. Default: debug |  |
| label | string | No | Label to display with timing information. Default: " " |  |
| unit | string | No | Base unit for the timing, valid values are: - nano: nano seconds - micro : micro seconds - milli: milli seconds (default) - second: seconds |  |
| variable | string | No | The name of the variable in which to save the timer execution time into. |  |

# Examples

```cfml
<cftimer label="Nap time" type="outline">
  This case take run based upon time.
<cfset sleep(200)>
  <b>Successfully Stopped.</b>
</cftimer>
```








# Categories

[Debugging](../../categories/debugging.md)