# <cftimeout>

Whilst similar to a [<cfthread>](thread.md),  code run inside the [<cftimeout>](timeout.md) executes within the same scope as the current page

This tag **may** have a body.
This tag is also supported within [<cfscript>](script.md)

**Introduced:** 6.0.0.192

```
<cftimeout
    timespan=object
    onTimeout=any
    onError=any
    forcestop=boolean
><!--- body ---></cftimeout>
```

# Attributes

| Attribute | Type | Required | Description | Default |
|-----------|------|----------|-------------|---------|
| timespan | object | No | Specifies the maximum amount of time, in seconds, to wait for code inside this tag to execute. |  |
| onTimeout | any | No | A closure function (UDF) with the following signature: `function( timespan ) { }` |  |
| onError | any | No | A closure function (UDF) with the following signature: `function( error ) { }` |  |
| forcestop | boolean | No | Force the thread to stop once the execution exceeds the allowed timespan |  |

# Examples

```cfml
// timeout after 2sec
cftimeout( timespan=createTimeSpan(0, 0, 0, 2)){
	cfloop(times = "10"){
		cftimer(label = "Nap time" type = "outline") {
			echo("This case take run based upon time.");
			cfflush();
			sleep(400);
		}
	}
};
```








# Categories

[Threads](../../categories/thread.md)

# See Also

[Request Timeout](../../recipes/request-timeout.md), [<cfthread>](thread.md), [Timeout](../../recipes/timeout.md)