# <cfthrow>

The cfthrow tag raises a developer-specified exception that can be caught with [<cfcatch>](catch.md) tag
having any of the following type specifications

- cfcatch type = 'custom_type'
- cfcatch type = 'Application'
- cfcatch type = 'Any'

This tag **cannot** have a body.
This tag is also supported within [<cfscript>](script.md)

```
<cfthrow
    type=string
    message=any
    detail=string
    errorCode=string
    extendedInfo=string
    object=any
    cause=any
>
```

# Attributes

| Attribute | Type | Required | Description | Default |
|-----------|------|----------|-------------|---------|
| type | string | No | A custom type or the predefined type Application. Do not enter any other predefined types because they are not generated by CFML applications. If you specify the exception type Application, you need not specify a type for cfcatch, because the Application type is the default cfcatch type |  |
| message | any | No | A message that describes the exceptional event. |  |
| detail | string | No | A detailed description of the event. The CFML server appends the position of the error to this description; the server uses this parameter if an error is not caught by your code. |  |
| errorCode | string | No | A custom error code that you supply. |  |
| extendedInfo | string | No | extended information about the exception. |  |
| object | any | No | A native Java exception Object, if this attribute is defined, all other attributes are ignored |  |
| cause | any | No | the cause of the exception created with this tag. This can be a cfcatch block or a native java exception. |  |

# Examples

### Tag example

```cfml
<cftry>
    <cfthrow message="test exception">
    <cfcatch name="test" type="any">
        <cfdump var="#cfcatch#">
    </cfcatch>
</cftry>
```

### Script example

```cfml
 try {
        throw message="test exception"; //CF9+
    } catch (any e) {
        echo("#cfcatch#");
    }
```

### Adding additional info to an Exception using cause

```cfml
    try {
        try {
            throw message="test exception";
        } catch (any e) {
            // throw original exception with additional info, using "cause" Lucee 6+
            // see the "Caused by" at the bottom of the java stacktrace
            throw(message="error running batch", cause=e); 
        }
    } catch (ee){
        // this extra catch is to prevent trycf swallowing the exception detail
        echo(ee); 
    }
```








# Categories

[Debugging](../../categories/debugging.md)

# See Also

[Exception - Cause](../../recipes/exception-cause.md), [Exception Output](../../recipes/exception-output.md), [Throw()](../functions/throw.md), [<cfcatch>](catch.md), [<cffinally>](finally.md), [<cfrethrow>](rethrow.md), [<cfretry>](retry.md), [<cftry>](try.md)