# <cftable>

Builds a table in a CFML page.

Use the [<cfcol>](col.md) tag to define table column and row characteristics.

The cftable tag renders data either as preformatted text, or, with the HTMLTable attribute, as an HTML table.

Use cftable to create tables if you don't want to write HTML table tag code, or if your data can be well presented as preformatted text.

This tag **must** have a body.
This tag is also supported within [<cfscript>](script.md)

```
<cftable
    query=string
    maxRows=number
    colSpacing=number
    headerLines=number
    HTMLTable=boolean
    border=boolean
    colHeaders=boolean
    startRow=number
><!--- body ---></cftable>
```

# Attributes

| Attribute | Type | Required | Description | Default |
|-----------|------|----------|-------------|---------|
| query | string | Yes | Name of the cfquery from which to draw data. |  |
| maxRows | number | No | Maximum number of rows to display in the table. |  |
| colSpacing | number | No | Number of spaces to insert between columns 'default is 2'. |  |
| headerLines | number | No | Number of lines to use for the table header. The default is 2, which leaves one line between the headers and the first row of the table. |  |
| HTMLTable | boolean | No | Renders the table as an HTML 3.0 table. |  |
| border | boolean | No | Adds a border to the table. Use only when you specify the HTMLTable attribute for the table. |  |
| colHeaders | boolean | No | Displays headers for each column, as specified in the cfcol tag. |  |
| startRow | number | No | Specifies the query row from which to start processing. |  |

# Examples

```cfml
<cfset data = queryNew("id,name,age", "integer,varchar,integer", [
    {id:1,name:"Item1",age:20},
    {id:2,name:"Item2",age:24},
    {id:3,name:"Item3",age:44},
    {id:4,name:"Item4",age:42}
])>
<cfquery name="qryData" dbtype="query">
    SELECT *
    FROM data
</cfquery>
<cftable query="qryData" startRow="1" colSpacing="3"  border=true  HTMLTable colHeaders>
    <cfcol header="<b>Id</b>" align="Left" width="15" text="#id#">
    <cfcol header="<b>Name</b>" align="Left" width="15" text="#name#">
    <cfcol header="<b>Age</b>" align="Left" width="15" text="#age#">
</cftable>
```






