# <cfswitch>

Used with [<cfcase>](case.md) and [<cfdefaultcase>](defaultcase.md).

Evaluates a passed expression and passes control to the [<cfcase>](case.md) tag that matches the expression result.

You can optionally code a [<cfdefaultcase>](defaultcase.md) tag, which receives control if there is no matching [<cfcase>](case.md) tag value.

This tag **must** have a body.
This tag is also supported within [<cfscript>](script.md)

```
<cfswitch
    expression=string
><!--- body ---></cfswitch>
```

# Attributes

| Attribute | Type | Required | Description | Default |
|-----------|------|----------|-------------|---------|
| expression | string | Yes | Any CFML expression that yields a scalar value. CFML converts integers, real numbers, Booleans, and dates to numeric values. |  |

# Examples

```cfml
<cfoutput>
	<cfset expr = 2>
	<cfswitch expression="#expr#">
		<cfcase value=1>
			this is from case 2
		</cfcase>
		<cfcase value=2$3$4 delimiters="$">
			this is from case 2
		</cfcase>
		<cfdefaultcase>
			this is from default part
		</cfdefaultcase>
	</cfswitch>

	<cfscript>
	//Script example
		switch(1){
			case 1:
				result = 1;
				break;
			case 0:
				result = 0;
				break;
			default:
				result = "defaultCase";
		}
		writeDump(result);
	</cfscript>
</cfoutput>
```








# Categories

[Core CFML Language](../../categories/core.md)

# See Also

[<cfcase>](case.md), [<cfdefaultcase>](defaultcase.md)