# <cfstoredproc>

Executes stored procedures by an ODBC or native connection to a server database.

It specifies database connection information and identifies the stored procedure.

This tag **may** have a body.
This tag is also supported within [<cfscript>](script.md)

```
<cfstoredproc
    procedure=string
    timeout=number
    dataSource=object
    username=string
    password=string
    blockFactor=number
    debug=boolean
    returnCode=boolean
    result=string
    cachedAfter=datetime
    cachedWithin=object
    cacheName=string
><!--- body ---></cfstoredproc>
```

# Attributes

| Attribute | Type | Required | Description | Default |
|-----------|------|----------|-------------|---------|
| procedure | string | Yes | The name of the stored procedure on the database server. |  |
| timeout | number | No | timeout for the stored procedure. |  |
| dataSource | object | No | The name data source that points to the database that contains the stored procedure. |  |
| username | string | No | If specified, username overrides the username value specified in the data source setup. |  |
| password | string | No | If specified, password overrides the password value specified in the data source setup. |  |
| blockFactor | number | No | Specifies the maximum number of rows to fetch at a time from the server. The range is 1 which is the default to 100. The ODBC driver may dynamically reduce the block factor at runtime. |  |
| debug | boolean | No | Yes or No. Specifies whether debug info will be listed on each statement. Default is No. |  |
| returnCode | boolean | No | Yes or No. Specifies whether the tag populates cfstoredproc.statusCode with the status code returned by the stored procedure. Default is No. |  |
| result | string | No | Specifies a name for the structure in which cfstoredproc returns the statusCode and ExecutionTime variables. |  |
| cachedAfter | datetime | No | This is the age of which the query data can be |  |
| cachedWithin | object | No | possible values are: String "request": If original query was created within the current request, cached query data is used. a timespan (created with function CreateTimeSpan): If original query date falls within the time span, cached query data is used. To use cached data, the current query must use the same SQL statement, data source, query name, user name, and password. |  |

# Examples

### Sample content for storedproc

```cfml
<cfstoredproc procedure="games" datasource="dsname">
  <cfprocparam cfsqltype="CF_SQL_VARCHAR" value="#form.game1#">
  <cfprocparam cfsqltype="CF_SQL_VARCHAR" value="#form.game2#">
</cfstoredproc>
```








# Categories

[Queries](../../categories/query.md)

# See Also

[SQL Types](../../recipes/sql-types.md), [<cfprocparam>](procparam.md), [<cfquery>](query.md)