# <cfstopwatch>

Measures the time taken, in milliseconds, for the code between the start tag and end tag to execute.

This tag **must** have a body.
This tag is also supported within [<cfscript>](script.md)

```
<cfstopwatch
    label=string
    variable=string
><!--- body ---></cfstopwatch>
```

# Attributes

| Attribute | Type | Required | Description | Default |
|-----------|------|----------|-------------|---------|
| label | string | No | The label for the stopwatch, used in debugging output. |  |
| variable | string | No | The name of the variable which will contain the value of the time taken. |  |

# Examples

### Tags

```cfml
<cfstopwatch variable="stopwatchVar">
    <cfset i = 0>
    <cfloop from="1" to="10000" index="j">
        <cfset i++>
    </cfloop>
</cfstopwatch>

<cfdump var="#stopwatchVar#">
```

### Script

```cfml
stopwatch variable="stopwatchVar" {
    i = 0;
    loop from="1" to="10000" index="j" {
        i++;
    }
}
dump(stopwatchVar);
```






