# <cfslider>

Used inside [<cfform>](form.md), cfslider lets you place a slider control in a CFML form.

A slider control is like a sliding volume control.

The slider groove is the area over which the slider moves.

This tag **cannot** have a body.
This tag is also supported within [<cfscript>](script.md)

**Requires Extension:** [Form Tags for Jakarta EE (Lucee 7+)](https://download.lucee.org/#FAD67145-E3AE-30F8-1C11A6CCF544F0B7)

```
<cfslider
    name=string
    label=string
    refreshLabel=boolean
    range=string
    scale=number
    value=number
    onValidate=string
    message=string
    onError=string
    height=number
    width=number
    vSpace=number
    hSpace=number
    align=string
    tickMarkMajor=boolean
    tickMarkMinor=boolean
    tickMarkImages=string
    tickMarkLabels=string
    lookAndFeel=string
    vertical=boolean
    bgColor=string
    textColor=string
    font=string
    fontSize=number
    italic=boolean
    bold=boolean
    notSupported=string
>
```

# Attributes

| Attribute | Type | Required | Description | Default |
|-----------|------|----------|-------------|---------|
| name | string | Yes | A name for the cfslider control. |  |
| label | string | No | A label that displays with the slider control. |  |
| refreshLabel | boolean | No | Yes or No. If Yes, the label is not refreshed when the slider is moved. Default is Yes. |  |
| range | string | No | The values of the left and right slider range. The slider value displays as the slider is moved. Separate values by a comma. |  |
| scale | number | No | Unsigned integer. Defines the slider scale within the value of range. |  |
| value | number | No | The starting slider setting. Must be within the values specified in range. Defaults to the minimum value specified in range. |  |
| onValidate | string | No | The name of a valid JavaScript function used to validate user input; in this case, a change to the default slider value. |  |
| message | string | No | Message text to appear if validation fails. |  |
| onError | string | No | The name of a valid JavaScript function to execute in the event of a failed validation. |  |
| height | number | No | Height of the slider control, in pixels. |  |
| width | number | No | Width of the slider control, in pixels. |  |
| vSpace | number | No | Vertical margin spacing above and below slider control, in pixels. |  |
| hSpace | number | No | Horizontal margin spacing to the left and right of slider control, in pixels. |  |
| align | string | No | Alignment value. |  |
| tickMarkMajor | boolean | No | Yes to render major tickmarks in the slider scale. |  |
| tickMarkMinor | boolean | No | Yes to render minor tickmarks in the slider scale. |  |
| tickMarkImages | string | No | image used for tickmarks |  |
| tickMarkLabels | string | No | label used for tickmarks |  |
| lookAndFeel | string | No | A stylistic choice for the slider. |  |
| vertical | boolean | No | Yes renders the slider in the browser vertically. No renders the slider horizontally. This is the default. |  |
| bgColor | string | No | Background color of slider label. See textColor for color options. *Alias: bgcolour* |  |
| textColor | string | No | Slider label text color. Valid entries are: black, magenta, cyan, orange, darkgray, pink, gray, white, lightgray, yellow. *Alias: textcolour* |  |
| font | string | No | Font name for label text. |  |
| fontSize | number | No | Font size for label text measured in points. |  |
| italic | boolean | No | Yes for italicized label text, No for normal text. Default is No. |  |
| bold | boolean | No | Enter Yes for bold label text, No for medium text. Default is No. |  |
| notSupported | string | No | The text to display if a page containing a Java applet-based cfform control is opened by a browser that does not support Java or has Java support disabled. |  |

# Examples

*There are currently no examples for this tag.*








# Categories

[Ajax features](../../categories/ajax.md)

# See Also

[<cfform>](form.md)