# <cfsilent>

Suppresses all output that is produced by the CFML within the tag's scope.

This tag **must** have a body.
This tag is also supported within [<cfscript>](script.md)

```
<cfsilent
    bufferOutput=boolean
><!--- body ---></cfsilent>
```

# Attributes

| Attribute | Type | Required | Description | Default |
|-----------|------|----------|-------------|---------|
| bufferOutput | boolean | No | if set to true (default) the output written to the body of the tag is buffered and in case of an exception also outputted. if set to false the content to body is ignored and not disabled when a failure in the body of the tag occur. |  |

# Examples

### Tag example

```cfml
<cfset intA = 1>
<cfsilent>
	<cfset intA =intA+10 >
	<cfdump var="#intA#" />
</cfsilent>
<cfdump var="#intA#" />
```

### Script example

```cfml
	isExecuted=false;
	silent {
		writeoutput("text");
		isExecuted=true;
		writeDump("Inside dump executed: "&isExecuted);
	}
	writeDump("Outside dump executed: "&isExecuted);
```

### Cfsilent bufferoutput attribute example

```cfml
<h4>cfsilent bufferoutput=true</h4>
<cftry>
    <cfsilent bufferoutput="true">
        <cfset s = "the output before the exception must show with bufferoutput=true">
        <cfoutput>#s#</cfoutput>
        <cfthrow type="error">
    </cfsilent>
    <cfcatch>
        <br>  
        <cfoutput>from the cfcatch</cfoutput>
    </cfcatch>
</cftry>
<hr>

<h4>cfsilent bufferoutput=false</h4>
<cftry>
    <cfsilent bufferoutput="false">
        <cfset s = "the output before the exception must not show with bufferoutput=false">
        <cfoutput>#s#</cfoutput>
        <cfthrow type="error">
    </cfsilent>
    <cfcatch>
        <br>  
        <cfoutput>from the cfcatch</cfoutput>
    </cfcatch>
</cftry>

```








# See Also

[<cfsetting>](setting.md)