# <cfsetting>

Controls various aspects of page processing, such as the output of HTML code in pages.

One benefit of this option is managing whitespace that can occur in output pages served by CFML.

This tag **may** have a body.
This tag is also supported within [<cfscript>](script.md)

```
<cfsetting
    enableCFoutputOnly=any
    info=string
    listen=boolean
    showDebugOutput=boolean
    showDebug=boolean
    showDoc=boolean
    showMetric=boolean
    requestTimeOut=number
><!--- body ---></cfsetting>
```

# Attributes

| Attribute | Type | Required | Description | Default |
|-----------|------|----------|-------------|---------|
| enableCFoutputOnly | any | No | Yes, No or Reset. When set to Yes, cfsetting blocks output of HTML that resides outside cfoutput tags. When used multiple times, this setting is cumulative, so enabling it twice, requires to it to be turned off twice. Use `reset`, to reset that count and re-enable output of html outside cfoutput tags. |  |
| info | string | No | name of variable created for all information for this tag. |  |
| listen | boolean | No | do log all action, so it can report more detail with info. |  |
| showDebug | boolean | No | Yes or No. When set to No, showDebug suppresses debugging information that would otherwise display at the end of the generated page. |  |
| showDoc | boolean | No | Yes or No. When set to No, showDoc suppresses documentation/reference information that would otherwise display at the end of the generated page. |  |
| showMetric | boolean | No | Yes or No. When set to No, showMetric suppresses metric information that would otherwise display at the end of the generated page. |  |
| requestTimeOut | number | No | Number of seconds. Time limit, after which CFML processes the page as an unresponsive thread. Overrides the timeout set in the Lucee Administrator. If one specifies a `requesttimeout` of `0`, the request will not time out. |  |

# Examples

```cfml
<cfsetting enablecfoutputonly="true">
<cfset a = "Save">
<cfset b = "Tree">
<cfset c = a & b >
Save Water <cfoutput>#c#</cfoutput>
```








# Categories

[Debugging](../../categories/debugging.md), [Lucee Server related Tags, Functions and Guides](../../categories/server.md)

# See Also

[WriteOutput()](../functions/writeoutput.md), [Request Timeout](../../recipes/request-timeout.md), [<cfoutput>](output.md), [<cfprocessingdirective>](processingdirective.md), [<cfsilent>](silent.md)