# <cfselect>

Used inside [<cfform>](form.md), cfselect lets you construct a drop-down list box form control.

You can populate the drop-down list box from a query, or using the option tag.

Use option elements to populate lists.

The syntax for the option tag is the same as for its HTML counterpart.

This tag **must** have a body.
This tag is also supported within [<cfscript>](script.md)

**Requires Extension:** [Form Tags for Jakarta EE (Lucee 7+)](https://download.lucee.org/#FAD67145-E3AE-30F8-1C11A6CCF544F0B7)

```
<cfselect
    datafld=string
    caseSensitive=boolean
    datasrc=string
    dataformatas=string
    disabled=string
    multiple=string
    title=string
    dir=string
    lang=string
    onmousedown=string
    onmouseup=string
    onmouseover=string
    onmousemove=string
    onmouseout=string
    onkeypress=string
    onkeyup=string
    onkeydown=string
    name=string
    size=number
    required=boolean
    message=string
    onError=string
    query=string
    selected=string
    value=string
    display=string
    passThrough=any
    class=string
    id=string
    onBlur=string
    onChange=string
    onClick=string
    onDblclick=string
    onFocus=string
    style=string
    tabIndex=string
    label=string
    enabled=boolean
    group=string
    height=number
    queryPosition=string
    tooltip=string
    visible=boolean
    width=number
    editable=boolean
><!--- body ---></cfselect>
```

# Attributes

| Attribute | Type | Required | Description | Default |
|-----------|------|----------|-------------|---------|
| datafld | string | No | passed through to form tag created, only used for type html. |  |
| caseSensitive | boolean | No | is compare for selected case sensitive or not |  |
| datasrc | string | No | passed through to form tag created, only used for type html. |  |
| dataformatas | string | No | passed through to form tag created, only used for type html. |  |
| disabled | string | No | passed through to form tag created, only used for type html. |  |
| multiple | string | No | Yes or No. Yes permits selection of multiple elements in the drop-down list box. The default is No. |  |
| title | string | No | passed through to form tag created, only used for type html. |  |
| dir | string | No | passed through to form tag created, only used for type html. |  |
| lang | string | No | passed through to form tag created, only used for type html. |  |
| onmousedown | string | No | JavaScript to run when the user releases a mouse button in the control. |  |
| onmouseup | string | No | JavaScript to run when the user presses a mouse button in the control. |  |
| onmouseover | string | No | passed through to form tag created, only used for type html. |  |
| onmousemove | string | No | passed through to form tag created, only used for type html. |  |
| onmouseout | string | No | passed through to form tag created, only used for type html. |  |
| onkeypress | string | No | passed through to form tag created, only used for type html. |  |
| onkeyup | string | No | JavaScript to run when the user releases a keyboard key in the control. |  |
| onkeydown | string | No | JavaScript to run when the user depresses a keyboard key in the control. |  |
| name | string | Yes | Name of the form you are creating. |  |
| size | number | No | Number of entries in the drop-down list. |  |
| required | boolean | No | Yes or No. If Yes, a list element must be selected when the form is submitted, and the size of the drop-down list must be at least two. Default is No. |  |
| message | string | No | Message that displays if required = 'Yes' and no selection is made. |  |
| onError | string | No | The name of a valid JavaScript function to execute in the event of a failed validation. |  |
| query | string | No | Name of the query to be used to populate the drop-down list box. |  |
| selected | string | No | A value matching at least one entry in value to preselect the entry in the drop-down list box. |  |
| value | string | No | The query column value for the list element. Used with the query attribute. |  |
| display | string | No | The query column displayed. Defaults to the value of value. Used with the query attribute. |  |
| passThrough | any | No | HTML attributes that are not explicitly supported by cfselect. If you specify an attribute and its value, the attribute and its value are passed to the HTML code that is generated for the cfselect tag. |  |
| class | string | No | passed through to form tag created, only used for type html. |  |
| id | string | No | ID for form input element. |  |
| onBlur | string | No |  |  |
| onChange | string | No | JavaScript to run when the control changes due to user action. |  |
| onClick | string | No | JavaScript to run when the user clicks the control. |  |
| onDblclick | string | No | passed through to form tag created, only used for type html. |  |
| onFocus | string | No | passed through to form tag created, only used for type html. |  |
| style | string | No | Lucee passes the style attribute to the browser. |  |
| tabIndex | string | No | passed through to form tag created, only used for type html. |  |
| enabled | boolean | No | Flash only: Boolean value specifying whether to show the control. Space that would be occupied by an invisible control is blank. Default: true |  |
| group | string | No | Query column to use to group the items in the drop-down list into a two-level hierarchical list. |  |
| queryPosition | string | No | If you populate the options list with a query and use HTML option child tags to specify additional entries, determines the location of the items from the query relative to the items from the option tags: - above: Put the query items above the options items. - below: Put the query items below the options items. Default: above |  |

# Examples

```cfml
<cfform name="mycfform">
    -- year --
    <br />
    <cfselect name="year" enabled=true style="color:blue;" size=2>
        <option name="0" selected=true>--2024--</option>
        <option name="1">--2023--</option>
        <option name="3">--2022--</option>
        <option name="2">--2021--</option>
    </cfselect> <br />
    -- color --
    <br />
    <cfselect name="color" >
        <option name="0">--red--</option>
        <option name="1">--green--</option>
        <option name="2">--blue--</option>
    </cfselect>
</cfform>
```








# Categories

[Ajax features](../../categories/ajax.md)

# See Also

[<cfform>](form.md)