# <cfsearch>

Executes searches against data indexed

This tag **cannot** have a body.
This tag is also supported within [<cfscript>](script.md)

```
<cfsearch
    name=string
    collection=string
    type=string
    criteria=string
    maxRows=number
    startRow=number
    external=boolean
    language=string
    category=string
    categoryTree=string
    status=string
    suggestions=string
    contextPassages=number
    contextPassageLength=number
    contextBytes=number
    contextHighlightBegin=string
    contextHighlightEnd=string
    previousCriteria=string
>
```

# Attributes

| Attribute | Type | Required | Description | Default |
|-----------|------|----------|-------------|---------|
| name | string | Yes | A name for the search query. |  |
| collection | string | Yes | The logical collection name that is the target of the search operation or an external collection with fully qualified path. |  |
| type | string | No | Specifies the criteria type for the search. |  |
| criteria | string | No | Specifies the criteria for the search following the syntactic rules specified by type. |  |
| maxRows | number | No | Specifies the maximum number of entries for index queries. If omitted, all rows are returned. |  |
| startRow | number | No | Specifies the first row number to be retrieved. Default is 1. |  |
| category | string | No | A list of categories, separated by commas, to which the search is limited. If specified, and the collection does not have categories enabled, Lucee throws an exception. |  |
| categoryTree | string | No | The location in a hierarchical category tree at which to start the search. Lucee searches at and below this level. If specified, and the collection does not have categories enabled, Lucee throws an exception. Can be used in addition to category attribute. |  |
| status | string | No | Specifies the name of the structure variable into which Lucee places search information, including alternative criteria suggestions (spelling corrections). |  |
| suggestions | string | No | Specifies whether Lucene returns spelling suggestions for possibly misspelled words. |  |
| contextPassages | number | No | The number of passages/sentences Lucene returns in the context summary (that is, the context column of the results). Default: 3 |  |
| contextPassageLength | number | No | Used as a guide for splitting the text into paragraphs. The splitter tries to keep paragraphs close to this length while maintaining natural text boundaries. Note that paragraphs may exceed this length if no suitable break point is found. Default: 150 |  |
| contextBytes | number | No | The maximum number of bytes Lucene returns in the context summary. Default: 300 |  |
| contextHighlightBegin | string | No | The HTML to prepend to search terms in the context summary. Use this attribute in conjunction with contextHighlightEnd to highlight search terms in the context summary. Default: <b> |  |
| contextHighlightEnd | string | No | The HTML to prepend to search terms in the context summary. Use this attribute in conjunction with contextHighlightEnd to highlight search terms in the context summary. Default: </b> |  |

# Examples

*There are currently no examples for this tag.*








# Categories

[Search](../../categories/search.md)

# See Also

[Lucene 3 Extension](../../recipes/lucene-search.md), [<cfcollection>](collection.md), [<cfindex>](index.md), [Lucee uses Apache Lucene for full text indexing](../../guides/Various/TIPS/TIPS-serach-engine.md)