# <cfschedule>

Provides a programmatic interface to the scheduling engine.

You can run a specified page at scheduled intervals with the option to write out static HTML pages.

This lets you offer users access to pages that publish data, such as reports, without forcing users to wait while a database transaction
is performed in order to populate the data on the page.

[Scheduled Tasks - efficiently updating in a single operation](../../recipes/cfschedule-bulk-update.md)

This tag **cannot** have a body.
This tag is also supported within [<cfscript>](script.md)

```
<cfschedule
    action=delete|run|update|list|resume|pause
    serverPassword=string
    hidden=boolean
    readonly=boolean
    task=string
    operation=string
    paused=boolean
    file=string
    path=string
    startDate=any
    startTime=any
    url=string
    publish=boolean
    endDate=any
    endTime=any
    interval=string
    requestTimeOut=any
    username=string
    password=string
    proxyServer=string
    proxyUser=string
    proxyPassword=string
    userAgent=string
    resolveURL=boolean
    port=any
    proxyPort=any
    result=string
    autoDelete=boolean
    unique=boolean
>
```

# Attributes

| Attribute | Type | Required | Description | Default |
|-----------|------|----------|-------------|---------|
| action | string | Yes | - delete: deletes the specified task - update: updates an existing task or creates a new task, if one with the name specified by the task attribute does not exist - run: executes the specified task - list: list all scheduled tasks defined - pause: pause execution of the defined scheduled task - resume: resume execution of a paused scheduled task |  |
| serverPassword | string | No | allow you to access filesystem, also when access is denied for your context |  |
| hidden | boolean | No | if set to true the scheduled task is not displayed in the Lucee Administrator. |  |
| readonly | boolean | No | if set to true the scheduled task can not be modified or deleted in the Lucee Administrator. |  |
| task | string | No | The name of the task to delete, update, or run. |  |
| operation | string | No | The type of operation the scheduler performs when executing this task. - HTTPRequest: make a http(s) request to the url provided |  |
| paused | boolean | No | if set to true the scheduled task is paused. |  |
| file | string | No | Required with publish ='Yes' A valid filename for the published file. |  |
| path | string | No | Required with publish ='Yes' The path location for the published file. |  |
| startDate | any | No | Required when action ='update'. The date when scheduling of the task should start. |  |
| startTime | any | No | Required when creating tasks with action = 'update'. Enter a value in seconds. The time when scheduling of the task starts. |  |
| url | string | No | Required when action = 'update'. The URL to be executed. |  |
| publish | boolean | No | Specifies whether the result should be saved to a file. |  |
| endDate | any | No | The date when the scheduled task ends. |  |
| endTime | any | No | The time when the scheduled task ends. Enter a value in seconds. |  |
| interval | string | No | Required when creating tasks with action=`update`. Interval at which task should be scheduled. Can be defined in seconds or as - `Once` - `Daily` - `Weekly` - `Monthly` The default interval is one hour. The minimum interval is 10 seconds. |  |
| requestTimeOut | any | No | Customizes the requestTimeOut for the task operation. Can be used to extend the default timeout for operations that require more time to execute. Value in seconds. |  |
| username | string | No | Username if URL is protected. |  |
| password | string | No | Password if URL is protected. |  |
| proxyServer | string | No | Host name or IP address of a proxy server. |  |
| proxyUser | string | No | User name to provide to the proxy server. |  |
| proxyPassword | string | No | Password to provide to the proxy server. |  |
| userAgent | string | No | User agent request header. |  |
| resolveURL | boolean | No | Specifies whether to resolve links in the result page to absolute references. |  |
| port | any | No | The port number on the server from which the task is being scheduled. Default is 80. When used with resolveURL, the URLs of retrieved documents that specify a port number are automatically resolved to preserve links in the retrieved document. |  |
| proxyPort | any | No | The port number on the proxy server from which the task is being requested. Default is 80. When used with resolveURL, the URLs of retrieved documents that specify a port number are automatically resolved to preserve links in the retrieved document. |  |
| result | string | No | Return variable name of action list. Result attribute doesn't work with other actions. *Alias: returnvariable* |  |
| autoDelete | boolean | No | if set to true, the scheduled task get deleted when there is no possible future execution. |  |
| unique | boolean | No | if set to true, the scheduled task is only executed once at time.if a task is still running from previous round no new task is started. |  |

# Examples

### Syntax for cfschedule

```cfml
<cfschedule
    action="update"
    task="test"
    operation="HTTPRequest"
    startDate="6/02/2019"
    startTime="12:00 AM"
    url="https://www.test.com/schedule_task/test.cfm"
    interval="daily"
    publish = "Yes"
    file = "myfile.log"
    path = "#expandPath('./')#" />
```

### Action List

```cfml
<cfschedule action="list" returnvariable="res">
```

### Action Run

```cfml
<cfschedule action="run" task="taskOne">
```

### Action Pause

```cfml
<cfschedule action="pause" task="taskOne">
```

### Action Resume

```cfml
<cfschedule action="resume" task="taskOne">
```

### Action Delete

```cfml
<cfschedule action="delete" task="taskOne">
```








# See Also

[Scheduled Tasks - efficiently updating in a single operation](../../recipes/cfschedule-bulk-update.md), [Quartz Scheduler Clustering](../../recipes/scheduler-quartz-clustering.md), [Creating Component-Based Jobs with Quartz Scheduler](../../recipes/scheduler-quartz-component-jobs.md), [Quartz Scheduler](../../recipes/scheduler-quartz.md)