# <cfsavecontent>

Saves the generated content inside the tag body in a variable.

This tag **must** have a body.
This tag is also supported within [<cfscript>](script.md)

```
<cfsavecontent
    variable=string
    trim=boolean
    append=boolean
><!--- body ---></cfsavecontent>
```

# Attributes

| Attribute | Type | Required | Description | Default |
|-----------|------|----------|-------------|---------|
| variable | string | Yes | The name of the variable in which to save the generated content inside the tag. |  |
| trim | boolean | No | trim result |  |
| append | boolean | No | if true, the saved content will be appended to an already existing variable instead of overwriting it. |  |

# Examples

```cfml
<cfoutput>
	<cfsavecontent variable="test">
		Here you can add any cf, HTML elements etc.,
		Where you need it just place the variable of cfsavecontent, automatically shows the content stored here.
	</cfsavecontent>
	<cfsavecontent variable="example">
		<br>
		<input type="text" name="textfield">
	</cfsavecontent>
	#test#
	#example#
</cfoutput>
```

```cfml
	cfsavecontent( variable="test" ){
		echo("Here you can add any cf, HTML elements etc.,");
	}
	echo(test);
```





## Related System Properties / Environment Variables

- [LUCEE_SECURITY_LIMITEVALUATION](../../recipes/environment-variables-system-properties.md#lucee_security_limitevaluation) - Disable evaluating expressions when accessing scopes, Lucee 7 defaults to enabling this setting for security reasons. A boolean value. If enabled, limits variable evaluation in functions/tags. If enabled, you cannot use expressions within [ ] like this: susi[getVariableName()]. This affects the following functions: IsDefined, structGet, structSort (when using pathToSubElement), empty and the following tags: savecontent attribute `variable`
  ***Type:** boolean, **Default:** false (Lucee 6), true (Lucee 7)*



# Categories

[Core CFML Language](../../categories/core.md)

# See Also

[Render()](../functions/render.md)