# <cfregistry>

Reads, writes, and deletes keys and values in the system registry.

The cfregistry tag is supported on all platforms, including Windows, Linux, Solaris, and HP-UX.

This tag **cannot** have a body.
This tag is also supported within [<cfscript>](script.md)

```
<cfregistry
    action=getAll|get|set|delete
    branch=string
    type=string
    name=string
    sort=string
    entry=string
    variable=string
    value=string
>
```

# Attributes

| Attribute | Type | Required | Description | Default |
|-----------|------|----------|-------------|---------|
| action | string | Yes | action to the registry: - `getAll` - `get` - `set` - `delete` |  |
| branch | string | Yes | Name of a registry branch. |  |
| type | string | No | - `string`: return string values - `dWord`: return DWord values - `key`: return keys - `any`: return keys and values |  |
| name | string | No | Name of record set to contain returned keys and values. |  |
| sort | string | No | Sorts query column data (case-insensitive). Sorts on Entry, Type, and Value columns as text. Specify a combination of columns from query output, in a comma-delimited list. For example: `sort = "value desc, entry asc"` - `asc`: ascending (a to z) sort order - `desc`: descending (z to a) sort order |  |
| entry | string | No | Registry value to access. |  |
| variable | string | No | Variable into which to put value. |  |
| value | string | No | Value data to set. If you omit this attribute, `cfregistry` creates default value, as follows: - `string`: creates an empty string: "" - `dWord`: creates a value of 0 (zero) |  |

# Examples

```cfml
<cfregistry action = "getAll"
	branch = "HKEY_LOCAL_MACHINE\Software\Microsoft"
	type = "Any"
	name = "q_registry">
<cfdump var="#q_registry#">
```








# Categories

[Lucee Server related Tags, Functions and Guides](../../categories/server.md)