# <cfproperty>

Defines components as complex types that are used for web services authoring.

The attributes of this tag are exposed as component metadata and are subject to inheritance rules.

Note: Lucee does not support 'lazy' attribute in cfproperty.

This tag **cannot** have a body.
This tag is also supported within [<cfscript>](script.md)

```
<cfproperty
    name=string
    type=string
    required=boolean
    default=object
    displayName=string
    hint=string
    access=string
    getter=boolean
    setter=boolean
>
```

# Attributes

| Attribute | Type | Required | Description | Default |
|-----------|------|----------|-------------|---------|
| name | string | Yes | A string; a property name. Must be a static value. |  |
| type | string | No | A string; a property type name; data type. |  |
| required | boolean | No | Whether the parameter is required |  |
| default | object | No | This sets the default value on the property when the object is created. |  |
| displayName | string | No | A value to be displayed when using introspection to show information about the CFC. The value appears in parentheses following the property name. |  |
| hint | string | No | Text to be displayed when using introspection to show information about the CFC. This attribute can be useful for describing the purpose of the parameter. |  |
| access | string | No | The client security context from which the method can be invoked |  |
| getter | boolean | No | Specifies whether to generate getter methods or not |  |
| setter | boolean | No | Specifies whether to generate setter methods or not |  |


# Usage Notes

Lucee 7 preserves property types and supports complex defaults [LDEV-801](https://luceeserver.atlassian.net/browse/LDEV-801)

# Examples

### Sample syntax

```cfml
 <cfproperty name="UnitId" column="unit_id" unique="true" fieldtype="id" type="string" />
```

### Serializing a CFC's properties to JSON

```cfml
myCfc = new component accessors="true"{
  property name="foo" type="string";
  property name="bar" type="numeric";
  // NOTE: nulls are skipped when serializing
  property name="unset" type="numeric";
  foo = "hello";
  bar = 42;
};
dump(myCfc); // See CFC object with properties
jsonString = serializeJson(var=myCfc, compact=false);
writeOutput(jsonString); // Output: {"foo":"hello","bar":42}
```

### Improve type handling and defaults with Lucee 7

```cfml
myCfc = new component accessors="true" {
  property name="foo" type="string";
  property name="bar" type="numeric";
  property name="arr" type="array" default="#[1,2,3]#";
  property name="st" type="struct" default="#{lucee:"rocks"}#";
  foo = "hello";
  bar = 42;
};
dump(myCfc); // See CFC object with properties
jsonString = serializeJson(var=myCfc, compact=false);
writeOutput(jsonString); // Output: {"foo":"hello","bar":42}
```








# See Also

[<cfcomponent>](component.md)