# <cfprocparam>

Specifies parameter information, including type, name, value, and length.

The cfprocparam tag is nested within a [<cfstoredproc>](storedproc.md) tag.

This tag **cannot** have a body.
This tag is also supported within [<cfscript>](script.md)

```
<cfprocparam
    type=string
    variable=string
    dbVarName=string
    value=any
    sqlType=string
    CFSQLType=string
    maxLength=number
    scale=number
    null=boolean
>
```

# Attributes

| Attribute | Type | Required | Description | Default |
|-----------|------|----------|-------------|---------|
| type | string | No | Indicates whether the passed variable is an input, output or input/output variable. Default is IN. The value IN passes the parameter by value. Values OUT and INOUT pass parameters as bound variables. |  |
| variable | string | No | The variable name that you use to reference the value that the output parameter represents after the call is made to the stored procedure. |  |
| value | any | No | Corresponds to the actual value that Lucee passes to the stored procedure. |  |
| sqlType | string | No | The SQL type that the parameter (any type) will be bound to. |  |
| maxLength | number | No | Maximum length of the parameter. |  |
| scale | number | No | Number of decimal places of the parameter. |  |
| null | boolean | No | Indicates whether the parameter is passed as a null. If you specify Yes, the tag ignores the value attribute. |  |

# Examples

*There are currently no examples for this tag.*








# Categories

[Queries](../../categories/query.md)

# See Also

[SQL Types](../../recipes/sql-types.md), [<cfstoredproc>](storedproc.md)