# <cfprocessingdirective>

Sets compiler directives that affect the entire template. Unlike most CFML tags, cfprocessingdirective is processed at compile time and must be placed at the root level of your template.

This tag **may** have a body.
This tag is also supported within [<cfscript>](script.md)

```
<cfprocessingdirective
    suppressWhiteSpace=boolean
    executionLog=boolean
    pageEncoding=string
    preserveCase=boolean
><!--- body ---></cfprocessingdirective>
```

# Attributes

| Attribute | Type | Required | Description | Default |
|-----------|------|----------|-------------|---------|
| suppressWhiteSpace | boolean | No | When set to true, removes unnecessary whitespace from the generated HTML output, reducing the file size and potentially improving page load times. This includes: -spaces -tabs -line breaks between HTML elements. Example: suppressWhiteSpace="true" |  |
| executionLog | boolean | No | Controls whether execution time logging is enabled for this template. When set to true, Lucee will log performance metrics for this template, which can be valuable for debugging and optimization. Example: executionLog="true" |  |
| pageEncoding | string | No | Specifies the character encoding used for the current template file. This must be a string literal corresponding to a valid character encoding (not a dynamic expression). Common values: -UTF-8 (Unicode, recommended for most applications) -ISO-8859-1 (Latin-1) -Windows-1252 (Windows Western European). Example: pageEncoding="UTF-8" |  |
| preserveCase | boolean | No | Controls how variable keys defined using dot notation are handled: When preserveCase="false" (default): All struct keys defined with dot notation are converted to uppercase. Example: sct.dotNotation becomes key "DOTNOTATION" while sct["bracketNotation"] remains "bracketNotation" When preserveCase="true": Struct keys defined with dot notation maintain their original case. Example: sct.dotNotation remains key "dotNotation" and sct["bracketNotation"] remains "bracketNotation" This setting affects all dot notation usage throughout the template. |  |

# Examples

### Simple Example

```cfml
<cfprocessingdirective suppresswhitespace="true" executionlog="true" pageencoding="UTF-8" preservecase="false">
    <cfset myStruct = {}>
    <cfset myStruct.dotNotation = "Hello World">
    <cfset myStruct["bracketNotation"] = " utf-8 Encoding">
<cfdump var="#myStruct#" label="preservecase"/>
    <cfoutput>
        Dot Notation :   #myStruct.DOTNOTATION#<br>
        Bracket Notation : #myStruct["bracketNotation"]#
    </cfoutput>
</cfprocessingdirective>
```








# Categories

[Debugging](../../categories/debugging.md), [Lucee Server related Tags, Functions and Guides](../../categories/server.md)

# See Also

[<cfoutput>](output.md), [<cfsetting>](setting.md)