# <cfpop>

Retrieves and deletes e-mail messages from a POP mail server.

This tag **cannot** have a body.
This tag is also supported within [<cfscript>](script.md)

```
<cfpop
    connection=string
    server=string
    uid=string
    port=number
    username=string
    password=string
    secure=boolean
    action=getHeaderOnly|getAll|delete
    name=string
    messageNumber=string
    attachmentPath=string
    timeout=number
    debug=boolean
    maxRows=number
    startRow=number
    generateUniqueFilenames=boolean
    delimiter=string
>
```

# Attributes

| Attribute | Type | Required | Description | Default |
|-----------|------|----------|-------------|---------|
| connection | string | No | label for a connection. |  |
| server | string | No | Host name biff.upperlip.com or IP address 192.1.2.225 of the POP server. |  |
| uid | string | No | UID or a comma-delimited list of UIDs to get or delete. Invalid UIDs are ignored. |  |
| port | number | No | Defaults to the standard POP port, 110. |  |
| username | string | No | If no user name is specified, the POP connection is anonymous. |  |
| password | string | No | Password that corresponds to user name. |  |
| secure | boolean | No | enables SSL for pop requests |  |
| action | string | No | Specifies the mail action. - getHeaderOnly: returns message header information only - getAll: returns message header information, message text, and attachments if attachmentPath is specified - delete: deletes messages on POP server | getHeaderOnly |
| name | string | No | Name for the index query. *Alias: variable* |  |
| messageNumber | string | No | Can be a comma-separated list of the message ids |  |
| attachmentPath | string | No | Allows attachments to be written to the specified directory when action = "getAll". If an invalid attachmentPath is specified, no attachment files are written to the server. |  |
| timeout | number | No | Specifies the maximum time, in seconds, to wait for mail processing. Defaults is 60 seconds. |  |
| maxRows | number | No | Sets the number of messages returned, starting with the number in the startRow attribute. This attribute is ignored if messageNumber is specified. |  |
| startRow | number | No | Specifies the first row number to be retrieved. Default is 1. This attribute is ignored if messageNumber is specified. |  |
| generateUniqueFilenames | boolean | No | Boolean indicating whether to generate unique filenames for the files attached to an e-mail message to avoid naming conflicts when the files are saved. Default is NO. |  |
| delimiter | string | No | Character that separates uid list, The default value is comma(,). *Alias: delimiters* |  |

# Examples

### Action getAll

```cfml
<cfpop action="getAll" username="#username#" password="#password#" server="#server_name#" uid="#uid#" name="res">
<cfdump var="#res#" />

<cfpop action="getAll" username="#username#" password="#password#" server="pop.mail.com" port="995" secure="true" name="message"
maxrows = "15" attachmentpath="#expandpath('./')#">
<cfdump var="#message#" />
```

### Action getHeaderOnly

```cfml
<cfpop action="getHeaderOnly" username="#username#" password="#password#" server="pop.mail.com" name="getHeader">
<cfdump var="#getHeader#" />
```

### Action delete

```cfml
<cfpop action="delete" username="#username#" password="#password#" server="pop.mail.com" uid="1RaJA7-1ioN2e27mu-00thu">
```








# Categories

[Internet Protocols](../../categories/protocols.md)

# See Also

[<cfimap>](imap.md), [<cfmail>](mail.md)