# <cfpdfparam>

Provides additional information for the cfpdf tag.

The cfpdfparam tag applies only to the merge action of the [<cfpdf>](pdf.md) tag and is always a child tag of the cfpdf tag.

This tag **cannot** have a body.
This tag is also supported within [<cfscript>](script.md)

**Requires Extension:** [PDF Extension for Jakarta EE (Lucee 7+)](https://download.lucee.org/#66E312DD-D083-27C0-64189D16753FD6F0)

```
<cfpdfparam
    pages=string
    password=string
    source=any
>
```

# Attributes

| Attribute | Type | Required | Description | Default |
|-----------|------|----------|-------------|---------|
| pages | string | No | Page number or Pages of the PDF source file to merge. You can specify a range of pages, for example - "1" - "1-5" - a comma-separated list of pages, for example, "1-5,9-10,18" |  |
| password | string | No | User or owner password, if the source PDF file is password-protected. |  |
| source | any | Yes | Source PDF file to merge. You can specify - a PDF variable - a cfdocument variable - a url to a PDF document - or the pathname to a file |  |

# Examples

```cfml
<cfset x = 1>

<cfdocument format="pdf" pagetype="A4" name="myVar">

<cfdocumentsection>

Hi there

</cfdocumentsection>

</cfdocument>



<cfpdf action="merge" destination="D:/myPDF.pdf" overwrite="yes">

<cfpdfparam source="myVar" /> 

</cfpdf>


```








# Categories

[PDFs](../../categories/pdf.md)

# See Also

[<cfpdf>](pdf.md)