# <cfpdf>

Manipulates existing PDF documents.

The following list describes some of the tasks you can perform with the cfpdf tag:

- Merge several PDF documents into one PDF document.
- Delete pages from a PDF document.
- Merge pages from one or more PDF documents and generate a new PDF document.
- Linearize PDF documents for faster web display.
- Remove interactivity from forms created in Acrobat(c) to generate flat PDF documents.
- Encrypt and add password protection to PDF documents.
- Generate thumbnail images from PDF documents or pages. (**not implemented yet**)
- Add or remove watermarks from PDF documents or pages.
- Retrieve information associated with a PDF document, such as the software used to generate the file or the author, and set information for a PDF document, such as the title, author and keywords.
- Create PDF portfolios
- Add and remove header/footer from PDF documents
- Optimize PDF documents
- Extract all the words from the pdf
- Extract images from PDF documents using the `extractimage` action.

This tag **may** have a body.
This tag is also supported within [<cfscript>](script.md)

**Requires Extension:** [PDF Extension for Jakarta EE (Lucee 7+)](https://download.lucee.org/#66E312DD-D083-27C0-64189D16753FD6F0)

```
<cfpdf
    action=addHeader|addFooter|addWatermark|deletePages|extractBookmarks|extractImage|extractText|getInfo|merge|open|removePassword|protect|read|removeWatermark|setInfo|thumbnail|write
    ascending=boolean
    type=string
    copyFrom=any
    ddxfile=string
    destination=string
    directory=string
    encrypt=string
    flatten=boolean
    foreground=boolean
    format=string
    image=any
    imagePrefix=string
    filter=string
    info=struct
    inputFiles=struct
    isBase64=boolean
    keepBookmark=boolean
    name=string
    newOwnerPassword=string
    newUserPassword=string
    opacity=number
    order=string
    outputFiles=struct
    overwrite=boolean
    pages=string
    password=string
    permissions=string
    position=string
    resolution=string
    rotation=number
    saveOption=string
    scale=number
    showOnPrint=boolean
    source=any
    stopOnError=boolean
    transparent=boolean
    version=number
    text=string
    numberformat=NUMERIC|LOWERCASEROMAN|UPPERCASEROMAN
    align=left|right|center
    leftmargin=numeric
    rightmargin=numeric
    topmargin=numeric
    bottommargin=numeric
><!--- body ---></cfpdf>
```

# Attributes

| Attribute | Type | Required | Description | Default |
|-----------|------|----------|-------------|---------|
| action | string | No | - addHeader - addFooter - addWatermark - deletePages - extractText - extractBookmarks - getInfo - merge - open - removePassword - protect - read - removeWatermark - setInfo - thumbnail - write - extractimage (default) - extractimages (alias for `extractimage`) **Note:** - The `thumbnail` action was implemented in PDF Extension version 1.1.0.8. - The `extractBookmarks` action was implemented in PDF Extension version 1.2.0.11-SNAPSHOT. |  |
| ascending | boolean | No | Order in which the PDF files are sorted |  |
| type | string | No | used for action "extractText", defines the format type of the extraction, valid values are: string,xml |  |
| copyFrom | any | No | Pathname of the PDF document from which to use the first page as a watermark |  |
| destination | string | No | Pathname of the modified PDF document. If the destination file exists, you must set the overwrite attribute to yes. If the destination file does not exist, CFML creates the file, if the parent directory exists. |  |
| directory | string | No | Directory of the PDF documents to merge. You must specify either the directory attribute or the source attribute. If you specify the directory attribute, CFML orders the documents by filename in descending order, by default. To change the order of the files, use the order attribute. |  |
| encrypt | string | No | Encryption type for the PDF output file |  |
| foreground | boolean | No | Placement of the watermark on the page |  |
| format | string | No | File type of thumbnail image output |  |
| image | any | No | Image used as a watermark. You can specify a pathname, a variable that contains an image file, or an image variable |  |
| imagePrefix | string | No | prefix used for each image thumbnail file generated. The image filenames use the format: imagePrefix_page_n.format. |  |
| filter | string | No | file filter, used with attribute directory |  |
| info | struct | No | Structure variable for relevant information |  |
| keepBookmark | boolean | No | Specifies whether bookmarks from the source PDF documents are retained in the merged document |  |
| name | string | No | PDF document variable name *Alias: variable* |  |
| newOwnerPassword | string | No | Password used to set permissions on a PDF document |  |
| newUserPassword | string | No | Password used to open PDF document |  |
| opacity | number | No | Opacity of the watermark. Valid values are integers in the range 0 (transparent) through 10 (opaque). |  |
| overwrite | boolean | No | Specifies whether PDF output overwrites the destination file |  |
| pages | string | No | Page or pages in the source PDF document on which to perform the action. You can specify multiple pages and page ranges as follows: "1,6-9,56-89,100, 110-120". |  |
| password | string | No | Owner or user password of the source PDF document, if the document is password-protected. |  |
| permissions | string | No | type of permissions on the PDF document |  |
| position | string | No | Position on the page where the watermark is placed. The position represents the top-left corner of the watermark. Specify the x and y coordinates; for example "50,30". |  |
| resolution | string | No | Image quality used to generate thumbnail images |  |
| rotation | number | No | Degree of rotation of the watermark image on the page. |  |
| scale | number | No | Size of the thumbnail relative to the source page. The value represents a percentage from 1 through 100. |  |
| source | any | No | PDF document used as the source. |  |
| stopOnError | boolean | No | Valid only if the directory attribute is specified. If the specified directory contains files other then readable PDF files, Lucee either stops merge process or continues. |  |
| transparent | boolean | No | (format="png" only) Specifies whether the image background is transparent or opaque |  |
| version | number | No | Version of the PDF used to write the document |  |
| text | string | No | text for header or footer, you can add the following place holders within the text: - _PAGELABEL: add current page label - _LASTPAGELABEL: add last page label - _PAGENUMBER: add current page number - _LASTPAGENUMBER: add last page number |  |
| numberformat | string | No | Specify the numbering format for PDF pages in the header/footer. possible values are: - LOWERCASEROMAN - UPPERCASEROMAN - NUMERIC |  |
| align | string | No | Aligns the header and footer in PDF: - left - right - center |  |
| leftmargin | numeric | No | left margin of the text in header/footer |  |
| rightmargin | numeric | No | right margin of the text in header/footer |  |
| topmargin | numeric | No | top margin of the text in header |  |
| bottommargin | numeric | No | bottom margin of the text in footer |  |

# Examples

*There are currently no examples for this tag.*








# Categories

[PDFs](../../categories/pdf.md)

# See Also

[<cfdocument>](document.md), [<cfpdfparam>](pdfparam.md)