# <cfparam>

Tests for a parameter's existence, tests its data type, and provides a default value if one
is not assigned.

This tag **may** have a body.
This tag is also supported within [<cfscript>](script.md)

```
<cfparam
    name=string
    type=string
    default=any
    min=number
    max=number
    pattern=string
    maxLength=int
><!--- body ---></cfparam>
```

# Attributes

| Attribute | Type | Required | Description | Default |
|-----------|------|----------|-------------|---------|
| name | string | Yes | The name of the parameter to test, such as Client.Email or Cookie.BackgroundColor. If you omit the DEFAULT attribute, an error occurs if the specified parameter does not exist |  |
| type | string | No | The type of parameter that is required. The default is 'any' and valid values are: - any: any type of value - array: an array of values - binary: a binary value - boolean: a Boolean value - creditcard: a 13-16 digit number conforming to the mod10 algorithm - date or time: a date-time value - email: a valid e-mail address - eurodate: a date-time value. Any date part must be in the format dd/mm/yy. The format can use /, -, or . characters as delimiters - float or numeric: a numeric value - guid: a Universally Unique Identifier of the form "XXXXXXXX-XXXX-XXXX-XXXX-XXXXXXXXXXXX" where X is a hexadecimal number - integer: an integer - query: a query object - range: a numeric range, specified by the min and max attributes - regex or regular_expression: matches input against pattern attribute - ssn or social_security_number: a U.S. social security number - string: a string value or single character - struct: a structure - telephone: a standard U.S. telephone number - url: an http, https, ftp, file, mailto, or news URL - uuid: a ColdFusion Universally Unique Identifier, formatted XXXXXXXX-XXXX-XXXX-XXXXXXXXXXXXXXX, where X is a hexadecimal number. See CreateUUID - usdate: a U.S. date of the format mm/dd/yy, with 1-2 digit days and months, 1-4 digit years - variableName: a string formatted according to ColdFusion variable naming conventions - xml: XML objects and XML strings - zipcode: U.S., 5- or 9-digit format ZIP codes |  |
| default | any | No | Default value to set the parameter to if it does not exist. |  |
| min | number | No | define the smallest size of a numeric value, used for type range |  |
| max | number | No | define the biggest size of a numeric value, used for type range |  |
| pattern | string | No | define a regular expression pattern, to check value against |  |
| maxLength | int | No | define the maxlength of a value for this types: email, url and string |  |

# Examples

### Simple Example

### Tag example

```cfml
<cfparam name="FORM.test" default="1">
<cfif FORM.test EQ '1'>
    <cfset isError = false>
<cfelse>
  <cfset isError = true>
</cfif>
<cfoutput>#isError#</cfoutput>
```

### Script example

```cfml
  param name="FORM.test" default="1";
    if(FORM.test EQ '1') {
        isError = false;
    }
    else {
        isError = true;
    }
    writeoutput("#isError#")
```








# Categories

[Core CFML Language](../../categories/core.md)

# See Also

[<cfset>](set.md), [Data Types in Lucee](../../recipes/types-in-lucee.md)