# <cfoutput>

Displays the results of a database query or other operation.

To nest cfoutput tags, see the "Usage" section.

This tag **must** have a body.
This tag is also supported within [<cfscript>](script.md)

```
<cfoutput
    query=object
    group=string
    groupCaseSensitive=boolean
    startRow=number
    maxRows=number
    endRow=number
    encodeFor=string
><!--- body ---></cfoutput>
```

# Attributes

| Attribute | Type | Required | Description | Default |
|-----------|------|----------|-------------|---------|
| query | object | No | The name of the cfquery from which to draw data for the output section or the query itself. |  |
| group | string | No | Specifies the query column to use when you group sets of records together. Use this attribute if you have retrieved a record set ordered on a certain query column. For example, if a record set is ordered according to "CustomerID" in the cfquery tag, you can group the output on "CustomerID." The group attribute, which is case sensitive, eliminates adjacent duplicates when the data is sorted by the specified field. See the groupCaseSensitive attribute for information about specifying a case insensitive grouping. |  |
| groupCaseSensitive | boolean | No | Boolean indicating whether to group by case. The default value is YES; case is considered while grouping. If the query attribute specifies a query object that was generated by a case-insensitive SQL query, set the groupCaseSensitive attribute to NO to keep the recordset intact. |  |
| startRow | number | No | Specifies the row from which to start output. |  |
| maxRows | number | No | Specifies the maximum number of rows to display in the output section. You cannot use this attribute together with the attribute endRow. |  |
| endRow | number | No | Last row of query that is included. You cannot use this attribute together with the attribute maxRows. |  |
| encodeFor | string | No | encode for what, valid values are: - **css:** for output inside Cascading Style Sheets (CSS) - **dn:** for output in LDAP Distinguished Names - **html:** for output inside HTML - **html_attr:** for output inside HTML Attributes - **javascript:** for output inside JavaScript - **ldap:** for output in LDAP queries - **url:** for output in URL - **vbscript:** for output inside vbscript - **xml:** for output inside XML - **xml_attr:** for output inside XML Attributes - **xpath:** for output in XPath |  |

# Examples

### Simple example

```cfml
<cfset a=3>
<cfset b=8>
<cfloop index="i" from="#a#" to="#b#">
  <cfoutput>#i#</cfoutput>
</cfloop>
<br>
<cfset test = queryNew("name,age","varchar,numeric",{name:["Susi","Urs","john","jerry"],age:[20,20,28,32]})>
<cfoutput query="test" maxrows="3">
	#test.name#
	#test.age#
</cfoutput>
<br>
<cfoutput query="test" startrow="2" endrow="3">
	#test.name#
	#test.age#
</cfoutput><br>
<br>
<cfoutput query="test" group="age">
	#test.name#
	#test.age#
</cfoutput>
```








# Categories

[Core CFML Language](../../categories/core.md)

# See Also

[WriteOutput()](../functions/writeoutput.md), [<cfprocessingdirective>](processingdirective.md), [<cfsetting>](setting.md)