# <cfobject>

Lets you call methods in COM, CORBA, and JAVA objects.

This tag **cannot** have a body.
This tag is also supported within [<cfscript>](script.md)

```
<cfobject
    name=string
    component=string
    type=string
    action=create|connect
    class=string
    context=string
    delimiters=string
    server=string
    locale=string
    webservice=string
    username=string
    password=string
    proxyServer=string
    proxyPort=number
    proxyUser=string
    proxyPassword=string
>
```

# Attributes

| Attribute | Type | Required | Description | Default |
|-----------|------|----------|-------------|---------|
| name | string | Yes | name for the instantiated component. |  |
| component | string | No | Name of component to instantiate. |  |
| type | string | No | The object type. You can omit this attribute or specify component. Lucee automatically sets the type to component. |  |
| action | string | No | - create: instantiates a COM object (typically, a DLL) before invoking methods or properties. - connect: connects to a COM object (typically, an EXE) running on server. |  |
| class | string | No | Component ProgID for the object to invoke. When using Java stubs to connect to the COM object, the class must be the ProgID of the COM object. |  |
| context | string | No | - inproc - local - remote In Windows, if not specified, uses Registry setting. |  |
| delimiters | string | No | if specified a classpath, use as delimiter for the entries, default is comma. |  |
| server | string | No | Server name, using Universal Naming Convention (UNC) or Domain Name Serve (DNS) convention, in one of these forms: * \\lanserver * lanserver * <http://www.servername.com> * www.servername.com * 127.0.0.1 |  |
| locale | string | No | Sets arguments for a call to init_orb. Use this attribute only for VisiBroker ORBs. It is available on C++, Version 3.2. The value must be in the form: locale = " -ORBagentAddr 199.99.129.33 -ORBagentPort 19000" Each type-value pair must start with a hyphen. |  |
| webservice | string | No | The absolute URL of the web service. |  |
| username | string | No | The user name to use to access the web service. If the webservice attribute specifies a web service configured name in the Lucee Administrator, overrides any user name specified in the Administrator entry. |  |
| password | string | No | The password to use to access the web service. If the webservice attribute specifies a web service name configured in the Lucee Administrator, overrides any password specified in the Administrator entry. |  |
| proxyServer | string | No | The proxy server required to access the web service URL. |  |
| proxyPort | number | No | The port to use on the proxy server. |  |
| proxyUser | string | No | The user ID to send to the proxy server. |  |
| proxyPassword | string | No | The user's password on the proxy server. |  |

# Examples

*There are currently no examples for this tag.*








# Categories

[Components (CFCs)](../../categories/component.md), [Java](../../categories/java.md), [Objects](../../categories/object.md), [Web services](../../categories/webservice.md)

# See Also

[<cfcomponent>](component.md)