# <cfmodule>

Invokes a custom tag for use in cfml templates.

The [<cfmodule>](module.md) tag can help deal with custom tag name conflicts and differs from the use of [<cfinclude>](include.md) in that it does not share or affect the scope of the caller.

Use the template attribute to name a template that contains the custom tag definition, including its path.

Individual attributes or an `attributeCollection` may be passed as tag attributes, which will be exclusive to the scope of the module template called.

This tag **may** have a body.
This tag is also supported within [<cfscript>](script.md)

```
<cfmodule><!--- body ---></cfmodule>
```

*This tag does not use any attributes.*

# Examples

```
<cfmodule
    template="string"
    [attributeCollection="optional structure of attributes"]
    [attribute_1]
    [attribute_2]
>
```








# Categories

[Core CFML Language](../../categories/core.md)

# See Also

[<cfinclude>](include.md)