# <cfmailpart>

Specifies one part of a multipart e-mail message.

Can only be used in the [<cfmail>](mail.md) tag.

You can use more than one cfmailpart tag within a cfmail tag

This tag **must** have a body.
This tag is also supported within [<cfscript>](script.md)

```
<cfmailpart
    type=string
    wrapText=number
    charset=string
><!--- body ---></cfmailpart>
```

# Attributes

| Attribute | Type | Required | Description | Default |
|-----------|------|----------|-------------|---------|
| type | string | Yes | The MIME media type of the part |  |
| wrapText | number | No | Specifies the maximum line length, in characters of the mail text |  |
| charset | string | No | The character encoding in which the part text is encoded |  |

# Examples

### Example for Mailpart

```cfml
<cfmail from="test@gmail.com" to="chk@gmail.com" subject="Testing emailpart" server="localhost">
  <cfmailpart type="text/plain"/>
    <cfoutput>This is test of cfmailpart</cfoutput>
</cfmail>
```





## Related System Properties / Environment Variables

- [LUCEE_MAIL_USE_7BIT_TRANSFER_ENCODING_FOR_HTML_PARTS](../../recipes/environment-variables-system-properties.md#lucee_mail_use_7bit_transfer_encoding_for_html_parts) - Enabled by default in Lucee 7
  ***Type:** boolean, **Default:** true*



# See Also

[Sending Emails](../../recipes/mail-how-to-send-a-mail.md), [<cfmail>](mail.md)