# <cfmailparam>

Can either attach a file or add a header to a message.

It is nested within a [tag-mail] tag.

You can use more than one cfmailparam tag within a cfmail tag.

This tag **cannot** have a body.
This tag is also supported within [<cfscript>](script.md)

```
<cfmailparam
    file=string
    filename=string
    name=string
    value=string
    type=string
    disposition=string
    contentId=string
    remove=boolean
    content=any
>
```

# Attributes

| Attribute | Type | Required | Description | Default |
|-----------|------|----------|-------------|---------|
| file | string | No | Attaches the specified file to the message. This attribute is mutually exclusive with the name attribute. |  |
| filename | string | No | file name used for the file attached with the attribute "file", if not set the name of the file itself is used. |  |
| name | string | No | Specifies the name of the header. Header names are case insensitive. This attribute is mutually exclusive with the file attribute. |  |
| value | string | No | Indicates the value of the header. |  |
| type | string | No | The MIME media type of the part. |  |
| disposition | string | No | How the attached file is to be handled. Can be one of the following: - attachment: presents the file as an attachment. - inline: displays the file contents in the message. |  |
| contentId | string | No | The Identifier for the attached file. This ID should be globally unique and is used to identify the file in an IMG or other tag in the mail body that references the file content. |  |
| remove | boolean | No | remove attachment from filesystem after the mail is successfully sent |  |
| content | any | No | send given value as attachment |  |

# Examples

### Simple example for cfmailparam

```cfml
<cftry>
	<cfmail from="sender@example.com" to="receiver@example.com" subject="mailparam example" server="smtp.gmail.com">
		<cfmailparam name="header" value="Mail header">
		Mailparam header example
	</cfmail>
	<cfcatch>
		<cfdump var="#cfcatch.message#" />
	</cfcatch>
</cftry>
```








# See Also

[Sending Emails](../../recipes/mail-how-to-send-a-mail.md), [<cfmail>](mail.md)