# <cfmail>

Sends e-mail messages by an SMTP server.

This tag **must** have a body.
This tag is also supported within [<cfscript>](script.md)

```
<cfmail
    from=object
    to=object
    cc=object
    bcc=object
    replyTo=object
    failTo=object
    subject=string
    type=string
    maxRows=number
    mimeAttach=string
    listener=any
    query=string
    group=string
    groupCaseSensitive=boolean
    startRow=number
    server=string
    port=number
    mailerID=string
    timeout=number
    username=string
    password=string
    wrapText=number
    charset=string
    async=boolean
    useTls=boolean
    priority=String
    useSsl=boolean
    proxyServer=string
    proxyPort=number
    proxyUser=string
    proxyPassword=string
    remove=boolean
    sendTime=datetime
    debug=boolean
><!--- body ---></cfmail>
```

# Attributes

| Attribute | Type | Required | Description | Default |
|-----------|------|----------|-------------|---------|
| from | object | Yes | The sender of the e-mail message. |  |
| to | object | Yes | The name of the e-mail message recipient. |  |
| cc | object | No | Indicates addresses to copy the e-mail message to; "cc" stands for "carbon copy." |  |
| bcc | object | No | Indicates addresses to copy the e-mail message to, without listing them in the message header. "bcc" stands for "blind carbon copy." |  |
| replyTo | object | No | Address(es) to which the recipient is directed to send replies. |  |
| failTo | object | No | Address to which mailing systems should send delivery failure notifications. Sets the mail envelope Return-Path value. |  |
| subject | string | Yes | The subject of the mail message. This field may be driven dynamically on a message-by-message basis |  |
| type | string | No | Specifies extended type attributes for the message. - text - plain - html - text/plain - text/html |  |
| mimeAttach | string | No | Specifies the path of the file to be attached to the e-mail message. An attached file is MIME-encoded. |  |
| listener | any | No | Listener for the mail. the listener can have 2 (optional) functions, "before" and "after" that get triggered before and after sending the mail. The functions get all data about the mail. Listener is only used when `async` (spoolEnable) is set to true. This attribute overwrites any mail listener defined in the `application.cfc/cfapplication`. The "before" function can also modify some data, by returning a struct containing the following keys: `[ from, to, bcc, cc, replyTo, failTo, subject, charset]` the listener can be a component looking like this: ``` component { function before( lastExecution, nextExecution, created, id, type, detail, tries, remainingTries, closed, caller, advanced ){} function after( lastExecution, nextExecution, created, id, type, detail, tries, remainingTries, closed, caller, advanced, passed, exception ){} } ``` a struct looking like this: `component {before:function(...){}, after:function(...){}}` |  |
| groupCaseSensitive | boolean | No | Boolean indicating whether to group with regard to case or not. The default value is NO; case is considered while grouping. If the query attribute specifies a query object that was generated by a case-insensitive SQL query, set the groupCaseSensitive attribute to NO to keep the recordset intact. |  |
| server | string | No | The address of the SMTP server to use for sending messages. If no server is specified, the server name specified in the Lucee Administrator is used. |  |
| port | number | No | The TCP/IP port on which the SMTP server listens for requests. This is normally 25. |  |
| mailerID | string | No | Specifies a mailer ID to be passed in the X-Mailer SMTP header, which identifies the mailer application. |  |
| timeout | number | No | The number of seconds to wait before timing out the connection to the SMTP server. |  |
| username | string | No | A user name to send to SMTP servers that require authentication. Requires a password attribute. |  |
| password | string | No | A password to send to SMTP servers that require authentication. Requires a username attribute. |  |
| wrapText | number | No | Specifies the maximum line length, in characters of the mail text. If a line has more than the specified number of characters, replaces the last white space character, such as a tab or space, preceding the specified position with a line break. If there are no white space characters, inserts a line break at the specified position. A common value for this attribute is 72. |  |
| charset | string | No | Character encoding of the mail message |  |
| async | boolean | No | if set to true, the mail is sent asynchronously by the Lucee Task manager (with multiple tries), if set to false the mail is sent in the same thread that executes the request, which is useful for troubleshooting because you get an error message if there is one. This setting overrides the setting with the same name in the Lucee Administrator. This attribute replaces the old "spoolenable" attribute which is still supported as an alias. *Alias: spoolenable* |  |
| useTls | boolean | No | Whether to use Transport Level Security. *Alias: tls, starttls* |  |
| priority | String | No | The message priority level. Can be one of the following values: * An integer in the range 1-5; 1 represents the highest priority. * One of the following string values, which correspond to the numeric values: highest or urgent, high, normal, low, and lowest or non-urgent. |  |
| useSsl | boolean | No | Whether to use Secure Sockets Layer. *Alias: ssl, secure* |  |
| proxyServer | string | No | Host name or IP address of a proxy server. |  |
| proxyPort | number | No | The port number on the proxy server from which the object is requested. Default is 80. When used with resolveURL, the URLs of retrieved documents that specify a port number are automatically resolved to preserve links in the retrieved document. |  |
| proxyUser | string | No | When required by a proxy server, a valid username. |  |
| proxyPassword | string | No | When required by a proxy server, a valid password. |  |
| remove | boolean | No | remove all attachments from filesystem after the mail is successfully sent |  |
| sendTime | datetime | No | Set a future date time to send an email in the future via the spooler. |  |
| debug | boolean | No | Whether to enable detailed logging to console. |  |

# Examples

### Simple example for cfmail

```cfml
<cftry>
 	<cfmail from="aaa@bb.com" to="test01@mail.com" subject="sample" cc="test02@gmail.com" server="example.mail.com">
		Test Email
	</cfmail>
	<cfcatch>
		<cfdump var="#cfcatch.message#">
	</cfcatch>
</cftry>
```





## Related System Properties / Environment Variables

- [LUCEE_MAIL_USE_7BIT_TRANSFER_ENCODING_FOR_HTML_PARTS](../../recipes/environment-variables-system-properties.md#lucee_mail_use_7bit_transfer_encoding_for_html_parts) - Enabled by default in Lucee 7
  ***Type:** boolean, **Default:** true*
- [LUCEE_SSL_CHECKSERVERIDENTITY](../../recipes/environment-variables-system-properties.md#lucee_ssl_checkserveridentity) - A boolean value. If enabled, checks the identity of the SSL certificate with SMTP
  ***Type:** boolean, **Default:** true*
- [LUCEE_USE_LUCEE_SSL_TRUSTSTORE](../../recipes/environment-variables-system-properties.md#lucee_use_lucee_ssl_truststore) - Specifies the file location of the trust store that contains trusted Certificate Authorities (CAs) for SSL/TLS connections in Java applications. Lucee 6 uses the JVM trust store by default
  ***Type:** string*



# Categories

[Core CFML Language](../../categories/core.md), [Internet Protocols](../../categories/protocols.md)

# See Also

[Sending Emails](../../recipes/mail-how-to-send-a-mail.md), [Mail Listeners](../../recipes/mail-listener.md), [<cfimap>](imap.md), [<cfmailparam>](mailparam.md), [<cfmailpart>](mailpart.md), [<cfpop>](pop.md), [Use cfmail with SSL authentication](../../guides/Various/TIPS/TIPS-cfmail-SSL-authentication.md)