# <cfloginuser>

Identifies an authenticated user to Lucee.

Specifies the user ID and roles. Used within a [<cflogin>](login.md) tag.

This tag **cannot** have a body.
This tag is also supported within [<cfscript>](script.md)

```
<cfloginuser
    name=string
    password=string
    roles=any
>
```

# Attributes

| Attribute | Type | Required | Description | Default |
|-----------|------|----------|-------------|---------|
| name | string | Yes | The Name of the User |  |
| password | string | Yes | The Password of the User |  |
| roles | any | Yes | The Roles of the user in comma separated form. |  |

# Examples

```cfml
<cflogin>
	<cfloginuser name = "test" password = "password" roles = "user,admin,editor">
</cflogin>
<cfdump var="#getAuthUser()#" />
<cfdump var="#getUserRoles()#" />
```





## Related System Properties / Environment Variables

- [LUCEE_LOGINSTORAGE_ITERATIONS](../../recipes/environment-variables-system-properties.md#lucee_loginstorage_iterations) - Specifies the number of encryption iterations for loginstorage
  ***Type:** numeric, **Default:** false*
- [LUCEE_LOGINSTORAGE_PRIVATEKEY](../../recipes/environment-variables-system-properties.md#lucee_loginstorage_privatekey) - A private key used to encrypt loginstorage. If not defined, a simple base64 encoding is used
  ***Type:** string*
- [LUCEE_LOGINSTORAGE_SALT](../../recipes/environment-variables-system-properties.md#lucee_loginstorage_salt) - The salt used for encrypting loginstorage. If no salt is defined, a hardcoded salt is used
  ***Type:** string*



# See Also

[GetAuthUser()](../functions/getauthuser.md), [GetUserRoles()](../functions/getuserroles.md), [IsUserInAnyRole()](../functions/isuserinanyrole.md), [IsUserInRole()](../functions/isuserinrole.md), [IsUserLoggedIn()](../functions/isuserloggedin.md), [<cflogin>](login.md), [<cflogout>](logout.md)