# <cflogin>

A container for user login and authentication code.

Lucee runs the code in this tag if a user is not already logged in.

You put code in the tag that authenticates the user and identifies the user with a set of roles. Used with [<cfloginuser>](loginuser.md) tag.

This tag **must** have a body.
This tag is also supported within [<cfscript>](script.md)

```
<cflogin
    idleTimeout=number
    applicationToken=string
    cookieDomain=string
><!--- body ---></cflogin>
```

# Attributes

| Attribute | Type | Required | Description | Default |
|-----------|------|----------|-------------|---------|

# Examples

```cfml
<cflogin>
	<cfloginuser name = "test" password = "password" roles = "user,admin,editor">
</cflogin>
<cfdump var="#getUserRoles()#" />

```





## Related System Properties / Environment Variables

- [LUCEE_LOGINSTORAGE_ITERATIONS](../../recipes/environment-variables-system-properties.md#lucee_loginstorage_iterations) - Specifies the number of encryption iterations for loginstorage
  ***Type:** numeric, **Default:** false*
- [LUCEE_LOGINSTORAGE_PRIVATEKEY](../../recipes/environment-variables-system-properties.md#lucee_loginstorage_privatekey) - A private key used to encrypt loginstorage. If not defined, a simple base64 encoding is used
  ***Type:** string*
- [LUCEE_LOGINSTORAGE_SALT](../../recipes/environment-variables-system-properties.md#lucee_loginstorage_salt) - The salt used for encrypting loginstorage. If no salt is defined, a hardcoded salt is used
  ***Type:** string*



# See Also

[GetAuthUser()](../functions/getauthuser.md), [GetUserRoles()](../functions/getuserroles.md), [IsUserInAnyRole()](../functions/isuserinanyrole.md), [IsUserInRole()](../functions/isuserinrole.md), [IsUserLoggedIn()](../functions/isuserloggedin.md), [<cfloginuser>](loginuser.md), [<cflogout>](logout.md)