# <cflog>

Writes a message to a log file.

This tag **cannot** have a body.
This tag is also supported within [<cfscript>](script.md)

```
<cflog
    text=string
    exception=any
    charset=string
    log=string
    file=string
    async=boolean
    type=string
    thread=boolean
    date=boolean
    time=boolean
    application=boolean
>
```

# Attributes

| Attribute | Type | Required | Description | Default |
|-----------|------|----------|-------------|---------|
| text | string | No | The message to log *Alias: message* |  |
| exception | any | No | An exception to log |  |
| charset | string | No | Character set name for the file contents. |  |
| log | string | No | Specifies the log to which to write the message. This reference can be defined in the Lucee Administrator. Ignored if you specify a file attribute. *Alias: name* |  |
| async | boolean | No | only works in combination with the attribute "file", if set to true the file is written in a separate thread. *Alias: spoolenable* |  |
| type | string | No | the following is the log type (level) in decreasing order of severity: - fatal: Severe errors that cause premature termination. - error: Other runtime errors or unexpected conditions. - warn,warning: Use of deprecated APIs, poor use of API, 'almost' errors, other runtime situations that are undesirable or unexpected, but not necessarily "wrong". - info,information (default): Interesting runtime events. - debug: Detailed information on the flow through the system. - trace: Most detailed information. *Alias: level* |  |
| application | boolean | No | Specifies whether to log the application name if one has been specified in a cfapplication tag. |  |


# Usage Notes

For better performance, always use the `log` attribute with the name of a log which is either defined in the admin, or via [Application.cfc / <cfapplication>](application.md) `this.logs`

The `file` attribute is *deprecated* but still works, however, the file connection isn't cached, and will be slower than using a predefined `log`

# Examples

### Format for cflog

```cfml
<cflog text="Good things come in good times" log="myfile" type="information">
```








# Categories

[Debugging](../../categories/debugging.md)

# See Also

[Console logging using SystemOutput](../../recipes/console-logging.md), [WriteLog()](../functions/writelog.md), [Logging](../../recipes/logging.md)