# <cflock>

Provides two types of locks to ensure the integrity of shared data: Exclusive lock and Read-only lock.

An exclusive lock single-threads access to the CFML constructs in its body. Single-threaded access
implies that the body of the tag can be executed by at most one request at a time. A request executing
inside a cflock tag has an "exclusive lock" on the tag. No other requests can start executing inside the
tag while a request has an exclusive lock. Lucee issues exclusive locks on a first-come, first-served
basis.

A read-only lock allows multiple requests to access the CFML constructs inside its body concurrently.
Therefore, read-only locks should be used only when the shared data is read only and not modified. If another
request already has an exclusive lock on the shared data, the request waits for the exclusive lock to be
released.

This tag **must** have a body.
This tag is also supported within [<cfscript>](script.md)

```
<cflock
    timeout=object
    scope=string
    name=string
    throwOnTimeout=boolean
    type=string
    result=string
><!--- body ---></cflock>
```

# Attributes

| Attribute | Type | Required | Description | Default |
|-----------|------|----------|-------------|---------|
| timeout | object | No | Specifies the maximum amount of time, in seconds, to wait to obtain a lock. If a lock can be obtained within the specified period, execution continues inside the body of the tag. Otherwise, the behavior depends on the value of the throwOnTimeout attribute. |  |
| scope | string | No | Specifies the scope as one of the following: Application, Server, or Session. This attribute is mutually exclusive with the name attribute. |  |
| name | string | No | Specifies the name of the lock. Only one request can execute inside a cflock tag with a given name. Therefore, providing the name attribute allows for synchronizing access to resources from different parts of an application. Lock names are global to a server. They are shared between applications and user sessions, but not across clustered servers. This attribute is mutually exclusive with the scope attribute. Therefore, do not specify the scope attribute and the name attribute in a tag. The value of name cannot be an empty string. *Alias: id* |  |
| throwOnTimeout | boolean | No | Yes or No. Specifies how timeout conditions are handled. If the value is Yes, an exception is generated to provide notification of the timeout. If the value is No, execution continues past the cfclock tag. Default is Yes. |  |
| type | string | No | readOnly or Exclusive. Specifies the type of lock: read-only or exclusive. Default is Exclusive. A read-only lock allows more than one request to read shared data. An exclusive lock allows only one request to read or write to shared data. |  |
| result | string | No | Specifies a name for the structure in which cflock returns the `statusCode` and `ExecutionTime` variables. Default variable is "cflock". *Alias: variable, variablename* |  |

# Examples

[https://www.youtube.com/watch?time_continue=4&v=x_TUx6EJ9nY](https://www.youtube.com/watch?time_continue=4&v=x_TUx6EJ9nY)





## Related System Properties / Environment Variables

- [LUCEE_TAG_POPULATE_LOCALSCOPE](../../recipes/environment-variables-system-properties.md#lucee_tag_populate_localscope) - Controls whether tags like cflock and cfquery populate their default result variables to local scope when inside a function. When `true`, variables go to local scope. When `false`, restores pre LDEV-5416 behavior where variables go to variables scope
  ***Type:** boolean, **Default:** true, **Introduced:** 7.0.1.13*



# Categories

[Core CFML Language](../../categories/core.md), [Scopes](../../categories/scopes.md), [Lucee Server related Tags, Functions and Guides](../../categories/server.md)

# See Also

[<cfdistributedlock>](distributedlock.md)