# <cflocation>

Redirect the current request to another URL.

For example, you might use [<cflocation>](location.md) to specify a standard message or response that you use in several applications.

Use the `addToken` attribute to verify client requests.

This tag **may** have a body.
This tag is also supported within [<cfscript>](script.md)

```
<cflocation
    url=string
    addToken=boolean
    abort=boolean
    statusCode=number
    encode=boolean
><!--- body ---></cflocation>
```

# Attributes

| Attribute | Type | Required | Description | Default |
|-----------|------|----------|-------------|---------|
| url | string | Yes | The URL of the HTML file or CFML page to open. |  |
| addToken | boolean | No | Yes or No. clientManagement must be enabled, see cfapplication. Yes appends client variable information to the URL you specify in the url. |  |
| abort | boolean | No | if set to true then the request will be aborted instead of redirected to allow developers to troubleshoot code that contains redirects |  |
| statusCode | number | No | statuscode used for the redirect (301 or 302) |  |
| encode | boolean | No | Encode the given URL value (changed behavior in Lucee 6.0) |  |

# Examples

### Syntax for cflocation

```cfml
<cflocation url="filename.ext" addToken="false">
```








# Categories

[Core CFML Language](../../categories/core.md)

# See Also

[Location()](../functions/location.md), [<cfforward>](forward.md)