# <cfldap>

Provides an interface to LDAP Lightweight Directory Access Protocol directory servers like the Microsoft Active Directory.

This tag **cannot** have a body.
This tag is also supported within [<cfscript>](script.md)

```
<cfldap
    returnAsBinary=string
    server=string
    port=number
    usetls=boolean
    username=string
    secure=string
    password=string
    action=add|delete|modifyDn|modify|query
    name=string
    timeout=number
    maxRows=number
    start=string
    scope=string
    attributes=string
    filter=string
    filterFile=string
    sort=string
    sortControl=string
    dn=string
    startRow=number
    modifyType=string
    rebind=boolean
    referral=number
    separator=string
    delimiter=string
>
```

# Attributes

| Attribute | Type | Required | Description | Default |
|-----------|------|----------|-------------|---------|
| returnAsBinary | string | No | A comma-delimited list of columns that are to be returned as binary values. |  |
| server | string | Yes | Host name "biff.upperlip.com" or IP address "192.1.2.225" of the LDAP server. |  |
| port | number | No | Port defaults to the standard LDAP port, 389. |  |
| usetls | boolean | No | use a secure connection. (but try secure="CFSSL_BASIC" instead) | false |
| username | string | No | If no user name is specified, the LDAP connection is anonymous. |  |
| secure | string | No | The type of security to use - CFSSL_BASIC - CFSSL_CLIENT_AUTH |  |
| password | string | No | used when username is defined |  |
| action | string | No | Specifies the LDAP action. - add - delete - modifydn - modify - query | query |
| name | string | No | The name you assign to the LDAP query. *Alias: variable* |  |
| timeout | number | No | Specifies the maximum amount of time, in milliseconds, to wait for LDAP processing. Defaults to 60000 ms (60 seconds). This was previously in seconds in Lucee 5, changed to match ACF since Lucee 6.0.0.170 |  |
| maxRows | number | No | Specifies the maximum number of entries for LDAP queries. |  |
| start | string | No | Specifies the distinguished name of the entry to be used to start the search. |  |
| scope | string | No | Specifies the scope of the search from the entry specified in the Start attribute for action = "Query". |  |
| attributes | string | No | Required if action = "Query", "Add", "ModifyDN", or "Modify" For queries: comma-delimited list of attributes to return. For queries, to get all attributes, specify "*". If action = "add" or "modify", you can specify a list of update columns. Separate attributes with a semicolon. If action = "ModifyDN", CFML passes attributes to the LDAP server without syntax checking. |  |
| filter | string | No | Search criteria for action = "Query". List attributes in the form: "(attribute operator value)" Example: "(sn = Smith)" |  |
| sort | string | No | Indicates the attribute or attributes by which to sort query results. Use a comma to separate attributes. |  |
| sortControl | string | No | Specifies how to sort query results. |  |
| dn | string | No | Specifies the distinguished name for update actions. |  |
| startRow | number | No | Used in conjunction with action = "Query". Specifies the first row of the LDAP query to insert into the query. The default is 1. |  |
| modifyType | string | No | Indicates whether to add, delete, or replace an attribute in a multi-value list of attributes. |  |
| referral | number | No | Number of hops allowed in a referral. A value of 0 disables referred addresses for LDAP; no data is returned. |  |
| separator | string | No | Specifies the character that cfldap uses to separate attribute values in multi-value attributes. This character is used by the `query`, `add`, and `modify` action attributes, and by cfldap to output multi-value attributes. The default character is the comma (,). |  |
| delimiter | string | No | Specifies the character that cfldap uses to separate multiple attribute name/value pairs when more than one attribute is specified in the attribute attribute or the attribute that you want to use has the default delimiter character, which is the semicolon (;), such as `mgrpmsgrejecttext;lang-en`. The delimiter character is used by the query, add, and modify action attributes, and is used by cfldap to output multi-value attributes |  |

# Examples

*There are currently no examples for this tag.*








# Categories

[LDAP](../../categories/ldap.md), [Internet Protocols](../../categories/protocols.md)

# See Also

[Setting Up Secure LDAP](../../guides/Various/TIPS/TIPS-LDAP.md)