# <cfinvoke>

Invokes component methods from within a page or component.

Use this tag to reference a WSDL file and consume a web service from within a block of CFML code.

This tag **may** have a body.
This tag is also supported within [<cfscript>](script.md)

```
<cfinvoke
    component=any
    method=string
    returnVariable=string
    username=string
    password=string
    webservice=string
    timeout=number
    proxyServer=string
    proxyPort=number
    proxyUser=string
    proxyPassword=string
    servicePort=string
><!--- body ---></cfinvoke>
```

# Attributes

| Attribute | Type | Required | Description | Default |
|-----------|------|----------|-------------|---------|
| component | any | No | String or component object; a reference to a component, or component to instantiate. |  |
| method | string | No | Name of a method. For a web service, the name of an operation. |  |
| returnVariable | string | No | Name of a variable for the invocation result. |  |
| username | string | No | Overrides username specified in Administrator > Web Services |  |
| password | string | No | Overrides password specified in Administrator > Web Services |  |
| webservice | string | No | The URL of the WSDL file for the web service. |  |
| proxyServer | string | No | The proxy server required to access the webservice URL. |  |
| proxyPort | number | No | The port to use on The proxy server. |  |
| proxyUser | string | No | The user ID to send to the proxy server. |  |
| proxyPassword | string | No | The user's password on the proxy server. |  |

# Examples

```cfml
<cfinvoke component="file.componentName" method="methodName" returnVariable="result" />
<cfdump var="#result#" />
```








# Categories

[Components (CFCs)](../../categories/component.md)

# See Also

[Invoke()](../functions/invoke.md), [<cfcomponent>](component.md), [<cfinvokeargument>](invokeargument.md)