# <cfinterface>

Defines an interface that consists of a set of signatures for functions.

The interface does not include the full function definitions; instead, you implement the functions in a Component.

The interfaces defined using this tag can be used to create a reusable application framework.

This tag **must** have a body.
This tag is also supported within [<cfscript>](script.md)

```
<cfinterface
    displayName=string
    extends=string
    hint=string
    javasettings=string
><!--- body ---></cfinterface>
```

# Attributes

| Attribute | Type | Required | Description | Default |
|-----------|------|----------|-------------|---------|
| displayName | string | No | A value to be displayed when using introspection to show a descriptive name for the interface. *Alias: name* |  |
| extends | string | No | A comma-delimited list of one or more interfaces that this interface extends. Any CFC that implements an interface must also implement all the functions in the interfaces specified by this property. If an interface extends another interface, and the child interface specifies a function with the same name as one in the parent interface, both functions must have the same attributes; otherwise it generates an error. |  |
| hint | string | No | Text to be displayed when using introspection to show information about the interface. The hint attribute value follows the syntax line in the function description. |  |
| javasettings | string | No | Specifies custom JavaSettings for this component. When provided, these settings override any environment-level JavaSettings that would otherwise be applied. |  |

# Examples

### Simple Example

```cfml
<cfinterface displayName="give_any_name" hint="interface test">
  <!--- Some functions here -->
</cfinterface>
```








# Categories

[Components (CFCs)](../../categories/component.md)

# See Also

[<cfcomponent>](component.md)