# <cfinput>

Used inside [<cfform>](form.md) to place radio buttons, checkboxes, or text boxes.

Provides input validation for the specified control type.

This tag **cannot** have a body.
This tag is also supported within [<cfscript>](script.md)

**Requires Extension:** [Form Tags for Jakarta EE (Lucee 7+)](https://download.lucee.org/#FAD67145-E3AE-30F8-1C11A6CCF544F0B7)

```
<cfinput
    autosuggest=string
    autosuggestBindDelay=number
    autosuggestMinLength=number
    delimiter=string
    maxResultsDisplayed=number
    onBindError=string
    showAutosuggestLoadingIcon=boolean
    sourceForTooltip=string
    typeahead=boolean
    validateAt=string
    type=string
    name=string
    value=string
    required=boolean
    range=string
    validate=string
    bind=string
    bindAttribute=string
    bindOnLoad=boolean
    border=string
    accept=string
    accesskey=string
    align=string
    alt=string
    checked=string
    daynames=string
    firstDayOfWeek=number
    monthNames=string
    height=string
    width=string
    hspace=string
    label=string
    mask=string
    notab=string
    datafld=string
    datasrc=string
    dataformatas=string
    disabled=string
    ismap=string
    readonly=string
    src=string
    usemap=string
    title=string
    dir=string
    lang=string
    onValidate=string
    pattern=string
    message=string
    onError=string
    size=string
    maxLength=number
    passThrough=any
    class=string
    id=string
    onBlur=string
    onChange=string
    onClick=string
    onDblclick=string
    onFocus=string
    onKeyDown=string
    onKeyPress=string
    onKeyUp=string
    onMouseDown=string
    onMouseMove=string
    onselect=string
    onMouseUp=string
    onMouseOut=string
    onMouseOver=string
    style=string
    tabIndex=string
    enabled=string
    visible=string
    tooltip=string
    autocomplete=string
    autofocus=string
    form=string
    formaction=string
    formenctype=string
    formmethod=string
    formnovalidate=string
    formtarget=string
    list=string
    max=string
    min=string
    multiple=string
    placeholder=string
    step=string
>
```

# Attributes

| Attribute | Type | Required | Description | Default |
|-----------|------|----------|-------------|---------|
| autosuggest | string | No | Specifies entry completion suggestions to display as the user types into a text input. The user can select a suggestion to complete the text entry. The valid value can be either of the following: - A string consisting of the suggestion values separated by the delimiter specified by the delimiter attribute. - A bind expression that gets the suggestion values based on the current input text. Valid only for cfinput type="text". |  |
| autosuggestBindDelay | number | No | The minimum time between autosuggest bind expression invocations, in seconds. Use this attribute to limit the number of requests that are sent to the server when a user types. Valid only for cfinput type="text" |  |
| autosuggestMinLength | number | No | The minimum number of characters required in the text box before invoking a bind expression to return items for suggestion. Valid only for cfinput type="text". |  |
| delimiter | string | No | The delimiter to use to separate entries in a static autosuggest list. This attribute is meaningful only if the autosuggest attribute is a string of delimited values. |  |
| maxResultsDisplayed | number | No | The maximum number suggestions to display in the autosuggest list. Valid only for cfinput type="text". |  |
| onBindError | string | No | The name of a JavaScript function to execute if evaluating a bind expression, including an autosuggest bind expression, results in an error. The function must take two attributes: an HTTP status code and a message. |  |
| showAutosuggestLoadingIcon | boolean | No | A Boolean value that specifies whether to display an animated icon when loading an autosuggest value for a text input. |  |
| sourceForTooltip | string | No | The URL of a page to display as a tool tip. The page can include HTML markup to control the format, and the tip can include images. If you specify this attribute, an animated icon appears with the text "Loading..." while the tip is being loaded. |  |
| typeahead | boolean | No | A Boolean value that specifies whether the autosuggest feature should automatically complete a user's entry with the first result in the suggestion list. Valid only for cfinput type="text". |  |
| validateAt | string | No | How to do the validation; one or more of the following: onSubmit, onServer or onBlur. onBlur and onSubmit are identical in Flash forms. For multiple values, use a comma-delimited list. Default: onSubmit |  |
| type | string | No | The input control type to create: - button: push button. - checkbox: check box. - file: file selector; not supported in Flash. - hidden: invisible control. - image: clickable button with an image. - password: password entry control; hides input values. - radio: radio button. - reset: form reset button. - submit: form submission button. - text: text entry box. - datefield: Flash only; date entry field with an expanding calendar for selecting dates. |  |
| name | string | Yes | A name for the form input element. |  |
| value | string | No | An initial value for the form input element. |  |
| required | boolean | No | Enter Yes or No. Default is No. |  |
| range | string | No | Enter a minimum and maximum value range, separated by a comma. Valid only for numeric data. |  |
| validate | string | No | - date: verifies format mm/dd/yy. - eurodate: verifies date format dd/mm/yyyy. - time: verifies time format hh:mm:ss. - float: verifies floating point format. - integer: verifies integer format. - telephone: verifies telephone format ###-###-####. The separator can be a blank. Area code and exchange must begin with digit 1 - 9. - zipcode: verifies, in U.S. formats only, 5- or 9-digit format #####-####. The separator can be a blank. - creditcard: strips blanks and dashes; verifies number using mod10 algorithm. Number must have 13-16 digits. - social_security_number: verifies format ###-##-####. The separator can be a blank. - regular_expression: matches input against pattern attribute. |  |
| bind | string | No | **(not supported)** A Flash bind expression that populates the field with information from other form fields. |  |
| bindAttribute | string | No | Specifies the HTML tag attribute whose value is set by the bind attribute. You can only specify attributes in the browser's HTML DOM tree, not Lucee-specific attributes. Ignored if there is no bind attribute. Valid only for cfinput type="text". |  |
| bindOnLoad | boolean | No | A Boolean value that specifies whether to execute the bind attribute expression when first loading the form. Ignored if there is no bind attribute. Valid only for cfinput type="text". |  |
| border | string | No | passed through to input tag created, only used for type html. |  |
| accept | string | No | passed through to input tag created, only used for type html. |  |
| accesskey | string | No | passed through to input tag created, only used for type html. |  |
| align | string | No | passed through to input tag created, only used for type html. |  |
| alt | string | No | passed through to input tag created, only used for type html. |  |
| checked | string | No | Selects a control. No value is required. Applies if type=radio or checkbox. Default: false |  |
| daynames | string | No | A comma-delimited list that sets the names of the weekdays displayed in the calendar. Sunday is the first day and the rest of the weekday names follow in the normal order. Default is: S,M,T,W,Th,F,S |  |
| firstDayOfWeek | number | No | Integer in the range 0-6 specifying the first day of the week in the calendar, 0 indicates Sunday, 6 indicates Saturday. Default is: 0 |  |
| monthNames | string | No | A comma-delimited list of the month names that are displayed at the top of the calendar. |  |
| height | string | No | Applies to most Flash types, HTML image type on some browsers. The height of the control, in pixels. The displayed height might be less than the specified size. |  |
| width | string | No | Applies to most Flash types, HTML image type on some browsers. The width of the control, in pixels. For Flash forms, Lucee ignores this attribute if you also specify a size attribute value. |  |
| hspace | string | No | passed through to form tag created, only used for type html. |  |
| label | string | No | Label to put next to the control on a Flash or XML form. Not used for button, hidden, image, reset, or submit types. |  |
| mask | string | No | A mask pattern that controls the character pattern that users can enter, or that the form sends to Lucee. In HTML and Flash for type=text use: - A = [A-Za-z] - X = [A-Za-z0-9] - 9 = [0-9] - ? = Any character - all other = the literal character In Flash for type=datefield use: - D = day; can use 0-2 mask characters. - M = month; can use 0-4 mask characters. - Y = year; can use 0, 2, or 4 characters. - E = day in week; can use 0-4 characters. |  |
| notab | string | No | passed through to form tag created, only used for type html. |  |
| datafld | string | No | passed through to form tag created, only used for type html. |  |
| datasrc | string | No | passed through to form tag created, only used for type html. |  |
| dataformatas | string | No | passed through to form tag created, only used for type html. |  |
| disabled | string | No | Disables user input, making the control read-only. To disable input, specify disabled without an attribute or disabled="true". To enable input, omit the attribute or specify disabled="false". |  |
| ismap | string | No | passed through to form tag created, only used for type html. |  |
| readonly | string | No | passed through to form tag created, only used for type html. |  |
| src | string | No | Applies to Flash button, reset, submit, and image types, and the HTML image type. URL of an image to use on the button. Flash does not support GIF images. |  |
| usemap | string | No | passed through to form tag created, only used for type html. |  |
| title | string | No | passed through to form tag created, only used for type html. |  |
| dir | string | No | passed through to form tag created, only used for type html. |  |
| lang | string | No | passed through to form tag created, only used for type html. |  |
| onValidate | string | No | The name of a JavaScript function used to validate user input. The form object, input object, and input object value are passed to the specified routine, which should return true if validation succeeds and false otherwise. If used, the validate attribute is ignored. |  |
| pattern | string | No | The JavaScript regular expression pattern to use to validate the input. Required only if you specify validate = "regular_expression". |  |
| message | string | No | Message text to appear if validation fails. |  |
| onError | string | No | The name of a JavaScript function you want to execute in the event of a failed validation. |  |
| size | string | No | The size of the input control. Ignored if type is Radio or Checkbox. |  |
| maxLength | number | No | The maximum length of text entered, if n type is Text. |  |
| passThrough | any | No | HTML attributes that are not explicitly supported by cfinput. If you specify an attribute and value, they are passed to the HTML code generated for the cfinput tag. |  |
| class | string | No | passed through to form tag created, only used for type html. |  |
| id | string | No | passed through to form tag created, only used for type html. |  |
| onBlur | string | No | passed through to form tag created, only used for type html. |  |
| onChange | string | No | passed through to form tag created, only used for type html. |  |
| onClick | string | No | passed through to form tag created, only used for type html. |  |
| onDblclick | string | No | passed through to form tag created, only used for type html. |  |
| onFocus | string | No | passed through to form tag created, only used for type html. |  |
| onKeyDown | string | No | passed through to form tag created, only used for type html. |  |
| onKeyPress | string | No | passed through to form tag created, only used for type html. |  |
| onKeyUp | string | No | passed through to form tag created, only used for type html. |  |
| onMouseDown | string | No | passed through to form tag created, only used for type html. |  |
| onMouseMove | string | No | passed through to form tag created, only used for type html. |  |
| onselect | string | No | passed through to form tag created, only used for type html. |  |
| onMouseUp | string | No | passed through to form tag created, only used for type html. |  |
| onMouseOut | string | No | passed through to form tag created, only used for type html. |  |
| onMouseOver | string | No | passed through to form tag created, only used for type html. |  |
| style | string | No | passed through to form tag created, only used for type html. |  |
| tabIndex | string | No | passed through to form tag created, only used for type html. |  |
| autocomplete | string | No | HTML attribute: Specifies the types of files that can be submitted through a file upload (only for type="file") |  |
| autofocus | string | No | Specifies that the input field should have focus on page load (not for type="hidden") |  |
| form | string | No | HTML attribute: Specifies one or more forms the input field belongs to |  |
| formaction | string | No | HTML attribute: Overrides the form's action attribute. Must be a valid URL that defines where to send the data when the form is submitted (for type="submit" and type="image") |  |
| formenctype | string | No | HTML attribute: Overrides the form's enctype attribute. Specifies how form-data should be encoded before sending it to the server (for type="submit" and type="image") |  |
| formmethod | string | No | HTML attribute: Overrides the form's method attribute. Defines the HTTP method for sending data to the action URL (for type="submit" and type="image") |  |
| formnovalidate | string | No | HTML attribute: Overrides the form's novalidate attribute. If present the input field should not be validated when submitted |  |
| formtarget | string | No | HTML attribute: Overrides the form's target attribute. Specifies the target window used when the form is submitted (for type="submit" and type="image") |  |
| list | string | No | HTML attribute: Refers to a datalist containing predefined options for the input field |  |
| max | string | No | HTML attribute: Specifies the input field's maximum value. Use together with the "min" attribute to create a range of legal values |  |
| min | string | No | HTML attribute: Specifies the input field's minimum value. Use together with the "max" attribute to create a range of legal values |  |
| multiple | string | No | HTML attribute: If present the user is allowed more than one value |  |
| placeholder | string | No | HTML attribute: Specifies a hint to help users fill out the input field |  |
| step | string | No | HTML attribute: Specifies the legal number intervals for the input field |  |

# Examples

```cfml
<cfform name="sampleForm">
    <label>FirstName:</label>
    <cfinput type ="Text" name ="firstname" 
    message ="Enter firstname" 
    required ="yes">
    <br/><br/>

    <label>Password:</label>
    <cfinput type ="password" name ="password" 
    message ="Enter password" 
    required ="yes">
</cfform>

```








# Categories

[Ajax features](../../categories/ajax.md)

# See Also

[<cfform>](form.md)