# <cfindex>

Populates collections with indexed data.

The [<cfindex>](index.md) and [<cfsearch>](search.md) tags encapsulate the indexing and searching utilities.

Collections can be populated from text files in a directory you specify, or from a query generated by a query.

Before you can populate a collection, you must create the collection using either the [<cfcollection>](collection.md) tag or the Lucee Administrator.

Use [<cfsearch>](search.md) to search collections populated via cfindex.

This tag **cannot** have a body.
This tag is also supported within [<cfscript>](script.md)

```
<cfindex
    name=string
    collection=string
    action=list|update|delete|purge|refresh
    type=string
    title=string
    key=string
    body=string
    custom1=string
    custom2=string
    custom3=string
    custom4=string
    URLpath=string
    extensions=string
    query=string
    recurse=boolean
    external=boolean
    language=string
    category=string
    categoryTree=string
    status=string
    prefix=string
    timeout=number
    throwontimeout=boolean
>
```

# Attributes

| Attribute | Type | Required | Description | Default |
|-----------|------|----------|-------------|---------|
| name | string | No | name of the variable generated by action "list" to return the query containing all indexes of a collection. *Alias: variable* |  |
| collection | string | Yes | Specifies a collection name. If you are indexing an external collection external = "Yes", specify the collection name, including fully qualified path. |  |
| action | string | Yes | Specifies the index action. |  |
| type | string | No | Specifies the type of entity being indexed. Default is CUSTOM. |  |
| title | string | No | Title for collection; Query column name for type and a valid query name; Permits searching collections by title or displaying a separate title from the key |  |
| key | string | No | - Absolute path and filename, if type = "file" - Absolute path, if type = "path" - A query column name (typically, the primary key column name), if type = "custom" - A query column name, if type = any other value This attribute is required for the actions listed, unless you intend for its value to be an empty string. |  |
| body | string | No | - ASCII text to index - Query column name(s), if name is specified in query You can specify columns in a delimited list. For example: - emp_name, dept_name, location" |  |
| custom1 | string | No | A custom field you can use to store data during an indexing operation. Specify a query column name for type and a query name. |  |
| custom2 | string | No | A custom field you can use to store data during an indexing operation. Usage is the same as for custom1. |  |
| custom3 | string | No | A custom field you can use to store data during an indexing operation. Usage is the same as for custom1. |  |
| custom4 | string | No | A custom field you can use to store data during an indexing operation. Usage is the same as for custom1. |  |
| URLpath | string | No | Specifies the URL path for files if type = "file" and type = "path". When the collection is searched with cfsearch, the pathname is automatically be prepended to filenames and returned as the url attribute. |  |
| extensions | string | No | Specifies the comma-separated list of file extensions that Lucee uses to index files if type = "Path". Default is HTM, HTML, CFM, CFML, DBM, DBML. An entry of "*." returns files with no extension |  |
| query | string | No | Specifies the name of the query against which the collection is generated. |  |
| recurse | boolean | No | Yes or No. Yes specifies, if type = "Path", that directories below the path specified in key are included in the indexing operation. |  |
| language | string | No | language used to index |  |
| category | string | No | A string value that specifies one or more search categories for which to index the data. You can define multiple categories, separated by commas, for a single index. |  |
| categoryTree | string | No | A string value that specifies a hierarchical category or category tree for searching. It is a series of categories separated by forward slashes ("/"). You can specify only one category tree. |  |
| status | string | No | The name of the structure into which Lucee returns status information. |  |
| timeout | number | No | the timeout in seconds for a single request of type url |  |

# Examples

### Syntax for cfindex

```cfml
<cfindex collection="collection_name" action="list" name="test_index" type="path" urlpath="#filepath#" extensions=".cfm,.cfc,.pdf,.docx">
```








# Categories

[Search](../../categories/search.md)

# See Also

[Lucene 3 Extension](../../recipes/lucene-search.md), [<cfcollection>](collection.md), [<cfsearch>](search.md), [Lucee uses Apache Lucene for full text indexing](../../guides/Various/TIPS/TIPS-serach-engine.md)