# <cfinclude>

Lets you embed references to pages in CFML.

You can embed cfinclude tags recursively.

This tag **cannot** have a body.
This tag is also supported within [<cfscript>](script.md)

```
<cfinclude
    template=string
    cachedWithin=object
    runOnce=boolean
>
```

# Attributes

| Attribute | Type | Required | Description | Default |
|-----------|------|----------|-------------|---------|
| template | string | Yes | A logical path to an existing page. |  |
| cachedWithin | object | No | possible values are: String "request": If original content was created within the current request, cached content data is used. a timespan (created with function CreateTimeSpan): If original content date falls within the time span, cached content data is used. To use cached data, the function must be called with the exact same arguments. |  |
| runOnce | boolean | No | if set to true, the given template is only included once within the current request. |  |

# Examples

### Format for Cfinclude

```cfml
<cfinclude template="test.cfm">
```





## Related System Properties / Environment Variables

- [LUCEE_MAPPING_FIRST](../../recipes/environment-variables-system-properties.md#lucee_mapping_first) - Let's say you have the following code: `<cfinclude template="/foo/bar/index.cfm">` And you have the following mappings defined: `/foo/bar` and `/foo`. Then Lucee will look for `/index.cfm` in `/foo/bar` and for `/bar/index.cfm` in `/foo` and invoke the first `index.cfm` it finds, which could be in both mappings. If this setting is set to `true`, Lucee will only check `/foo/bar` for `index.cfm`
  ***Type:** boolean, **Default:** true*



# Categories

[Core CFML Language](../../categories/core.md)

# See Also

[<cfexit>](exit.md), [<cfmodule>](module.md)