# <cfimap>

Retrieves and deletes email messages from an IMAP email server.

This tag works exactly the same way as the [<cfpop>](pop.md) tag. It has the same attributes.

The Internet Message Access Protocol or IMAP is one of two of the most prevalent Internet standard protocols for email retrieval, the other being POP3. Virtually all modern email clients and servers support both protocols as a means of transferring email messages from a server, such as those used by Gmail, or to a client such as Mozilla Thunderbird and Microsoft Outlook.

Many implementations of webmail use IMAP to retrieve email messages from a server and display them within a web browser, making the use of this protocol transparent to the user.

This tag **cannot** have a body.
This tag is also supported within [<cfscript>](script.md)

```
<cfimap
    connection=string
    server=string
    port=number
    uid=string
    username=string
    password=string
    secure=boolean
    action=getHeaderOnly|getAll|delete|open|close|markRead|createFolder|deleteFolder|renameFolder|listAllFolders|moveMail
    name=string
    messageNumber=string
    attachmentPath=string
    timeout=number
    maxRows=number
    startRow=number
    debug=boolean
    generateUniqueFilenames=boolean
    folder=string
    newFolder=string
    recurse=boolean
    delimiter=string
    stopOnError=boolean
>
```

# Attributes

| Attribute | Type | Required | Description | Default |
|-----------|------|----------|-------------|---------|
| connection | string | No | label for a connection. |  |
| server | string | No | Host name biff.upperlip.com or IP address 192.1.2.225 of the Imap server. |  |
| port | number | No | Defaults to the standard Imap port, 143. |  |
| uid | string | No | Specifies the unique ID or a comma-delimited list of Uids to retrieve or delete. If you set invalid Uids, then they are ignored. |  |
| username | string | No | If no user name is specified, the Imap connection is anonymous. |  |
| password | string | No | Password that corresponds to user name. |  |
| secure | boolean | No | enables SSL for pop requests |  |
| action | string | No | Specifies the IMAP action to perform. - getHeaderOnly - getAll - delete - open - close - markread - createfolder - deletefolder - renamefolder - listallfolders - movemail | getHeaderOnly |
| name | string | No | Name for the index query. *Alias: variable* |  |
| messageNumber | string | No | Can be a comma-separated list of the message ids |  |
| attachmentPath | string | No | Allows attachments to be written to the specified directory when action = "getAll". If an invalid attachmentPath is specified, no attachment files are written to the server. |  |
| timeout | number | No | Specifies the maximum time, in seconds, to wait for mail processing. Defaults is 60 seconds. |  |
| maxRows | number | No | Sets the number of messages returned, starting with the number in the startRow attribute. This attribute is ignored if messageNumber is specified. |  |
| startRow | number | No | Specifies the first row number to be retrieved. Default is 1. This attribute is ignored if messageNumber is specified. |  |
| generateUniqueFilenames | boolean | No | Boolean indicating whether to generate unique filenames for the files attached to an e-mail message to avoid naming conflicts when the files are saved. Default is NO. |  |
| folder | string | No | Folder for action, default is INBOX |  |
| newFolder | string | No | Name of new folder, used by action renameFolder and moveMail |  |
| recurse | boolean | No | Used for action listAllFolders |  |
| delimiter | string | No | Character that separates uid list, The default value is comma(,). *Alias: delimiters* |  |
| stopOnError | boolean | No | Stop execution on error, default is true |  |

# Examples

### Action getAll

```cfml
<cfimap
	action="getAll"
	server="#Imap.Server#"
	port="#Imap.Port#"
	username="#Imap.Username#"
	password="#Imap.Password#"
	secure="#Imap.Secure#"
	name="getAll" maxrows ="10" attachmentpath="#expandpath('./')#" generateuniquefilenames="true">
<cfdump var="#getAll#" />
```

### Action getHeaderOnly

```cfml
<cfimap
	action="getHeaderOnly"
	server="#Imap.Server#"
	port="#Imap.Port#"
	username="#Imap.Username#"
	password="#Imap.Password#"
	secure="#Imap.Secure#"
	name="getHeader" maxrows ="10">
<cfdump var="#getHeader#" />
```

### Action CreateFolder

```cfml
<cfimap
	action="CreateFolder"
	folder="NewFolderFromIMAP_Test"
	server="#Imap.Server#"
	port="#Imap.Port#"
	username="#Imap.Username#"
	password="#Imap.Password#"
	secure="#Imap.Secure#"
	name="CreateFolder">
```

### Action ListAllFolders

```cfml
<cfimap
	action="ListAllFolders"
	server="#Imap.Server#"
	port="#Imap.Port#"
	username="#Imap.Username#"
	password="#Imap.Password#"
	secure="#Imap.Secure#"
	name="ListAllFolders" maxrows ="10">
<cfdump var="#ListAllFolders#" />
```

### Action renamefolder

```cfml
	<cfimap
	action="renamefolder"
	folder="NewFolderFromIMAP_Test"
	newFolder="RenameFolderFromIMAP"
	server="#Imap.Server#"
	port="#Imap.Port#"
	username="#Imap.Username#"
	password="#Imap.Password#"
	secure="#Imap.Secure#">
```

### Action deletefolder

```cfml
	<cfimap
	action="deletefolder"
	folder="NewFolderFromIMAP_Test"
	server="#Imap.Server#"
	port="#Imap.Port#"
	username="#Imap.Username#"
	password="#Imap.Password#"
	secure="#Imap.Secure#"
	maxrows ="10">
```

### Action MoveMail

```cfml
<cfimap
	action="MoveMail"
	Newfolder="newfolder"
	messagenumber ="1"
	server="#Imap.Server#"
	port="#Imap.Port#"
	username="#Imap.Username#"
	password="#Imap.Password#"
	secure="#Imap.Secure#">
```

### Action MarkRead

```cfml
<cfimap
	action="MarkRead"
	server="#Imap.Server#"
	port="#Imap.Port#"
	username="#Imap.Username#"
	password="#Imap.Password#"
	secure="#Imap.Secure#">
```

### Action open

```cfml
<cfimap
	action="open"
	connection="openConnc"
	server="#Imap.Server#"
	port="#Imap.Port#"
	username="#Imap.Username#"
	password="#Imap.Password#"
	secure="#Imap.Secure#">
```

### Action close

```cfml
<cfimap action="close" connection="openConnc">
```

### Action Delete

```cfml
<cfimap
	action="delete"
	folder=""
	messagenumber ="1"
	server="#Imap.Server#"
	port="#Imap.Port#"
	username="#Imap.Username#"
	password="#Imap.Password#"
	secure="#Imap.Secure#">
```








# Categories

[Internet Protocols](../../categories/protocols.md)

# See Also

[Sending Emails](../../recipes/mail-how-to-send-a-mail.md), [<cfmail>](mail.md), [<cfpop>](pop.md)