# <cfimage>

Lets you resize and add labels to GIF and JPEG format images.

This tag **cannot** have a body.
This tag is also supported within [<cfscript>](script.md)

**Requires Extension:** [Image Extension for Jakarta EE (Lucee 7+)](https://download.lucee.org/#B737ABC4-D43F-4D91-8E8E973E37C40D1B)

```
<cfimage
    action=border|captcha|convert|writetobrowser|write|rotate|resize|read|info
    angle=number
    passthrough=string
    color=string
    destination=string
    difficulty=string
    fonts=any
    fontSize=number
    format=string
    height=string
    isBase64=boolean
    name=string
    overwrite=boolean
    quality=number
    source=any
    structName=string
    text=string
    thickness=number
    width=string
    base64=boolean
    nometadata=boolean
>
```

# Attributes

| Attribute | Type | Required | Description | Default |
|-----------|------|----------|-------------|---------|
| action | string | No | Action to execute. - border [ImageAddBorder()](../functions/imageaddborder.md) - captcha [ImageCaptcha()](../functions/imagecaptcha.md) - convert - writetobrowser [ImageWriteToBrowser()](../functions/imagewritetobrowser.md) - write [ImageWrite()](../functions/imagewrite.md) - rotate [ImageRotate()](../functions/imagerotate.md) - resize [ImageResize()](../functions/imageresize.md) - read [ImageRead()](../functions/imageread.md) - info [ImageInfo()](../functions/imageinfo.md) | read |
| angle | number | No | Angle in degrees to rotate the image. |  |
| passthrough | string | No | HTML attributes that are not explicitly supported by cfimage. If you specify an attribute and value, they are passed to the tag "img". |  |
| color | string | No | Border color. Hexadecimal value or supported named color. For a hexadecimal value, use the form "#xxxxxx" or "xxxxxx", where x = 0-9 or A-F; use two number signs or none. *Alias: colour* |  |
| destination | string | No | Absolute or relative pathname where the image output is written. The image format is determined by the file extension. The convert and write actions require a destination attribute. The border, captcha, resize, and rotate actions require a name attribute or a destination attribute. You can specify both. If you do not enter a destination, the CAPTCHA image is placed inline in the HTML output and displayed in the web browser. |  |
| difficulty | string | No | Level of complexity of the CAPTCHA text. Specify one of the following levels of text distortion: low, medium, high |  |
| fonts | any | No | One or more valid fonts to use for the CAPTCHA text. Separate multiple fonts with commas. Lucee supports only the system fonts that the JDK can recognize. For example, TTF fonts in the Windows directory are supported on Windows. |  |
| fontSize | number | No | font size of the text in the CAPTCHA image. |  |
| format | string | No | Format of the image displayed in the browser. If you do not specify a format, the image is displayed in PNG format. |  |
| height | string | No | Height in pixels of the image. For the resize attribute, you also can specify the height as a percentage. When you resize an image, if you specify a value for the width. |  |
| isBase64 | boolean | No | Specifies whether the source is a Base64 string |  |
| name | string | No | Name of the image variable to create. The read action requires a name attribute. The border, resize, and rotate actions require a name attribute or a destination attribute. You can specify both. *Alias: variable* |  |
| overwrite | boolean | No | If the destination file already exists, Lucee generates an error if the overwrite action is not set to yes. |  |
| quality | number | No | Quality of the JPEG destination file. Applies only to files with an extension of JPG or JPEG. Valid values are fractions that range from 0 through 1 (the lower the number, the lower the quality). |  |
| source | any | No | source file |  |
| structName | string | No | Name of the structure to be created. *Alias: result* |  |
| text | string | No | Text string displayed in the CAPTCHA image. Use capital letters for better readability. Do not include spaces because users cannot detect them in the resulting CAPTCHA image. |  |
| thickness | number | No | Border thickness in pixels. The border is added to the outside edge of the source image, increasing the image area accordingly. |  |
| width | string | No | Width in pixels of the image. |  |
| base64 | boolean | No | should action "writetobrowser" embed the source of the image as base64 encoded string, default is false. |  |
| nometadata | boolean | No | only used for action "write", if set to true, the meta data from a source image are NOT written to the destination image. |  |

# Examples

### Tag Syntax

### Image Write

```cfml
<cfset newImg = imageNew("",200,200,"rgb","blue")>
<cfimage action="write" source="#newImg#" name="writeimg" destination="pathname" overwrite="true">
```

### Image captcha

```cfml
<cfimage action="captcha" text="Captcha!" difficulty="low" height="30" width="150" fontSize="18"
fonts="Comic Sans MS,Times New Roman">
```

### Image read

```cfml
<cfimage action="read" name="sourceImage" source="https://avatars1.githubusercontent.com/u/10973141?s=280&v=4">
<cfdump var="#sourceImage#" />
```

### Image Info

```cfml
<cfimage action="info" structname="sourceImage" source="https://avatars1.githubusercontent.com/u/10973141?s=280&v=4">
<cfdump var="#sourceImage#" />

```

### Image convert

```cfml
<cfimage action="convert" structname="sourceImage" destination="#expandpath("./lii.jpeg")#"
source="https://avatars1.githubusercontent.com/u/10973141?s=280&v=4">
<cfimage action="writeToBrowser" source="#expandpath("./lii.jpeg")#">
```

### Image WriteToBrowser

```cfml
<cfimage action="writeToBrowser" source="https://avatars1.githubusercontent.com/u/10973141?s=280&v=4">
```

### Image Rotate

```cfml
<cfimage action="rotate" source="https://avatars1.githubusercontent.com/u/10973141?s=280&v=4"
destination="#expandPath( 'rotated.jpg' )#" overwrite="true" angle="30" quality="1">
<cfimage action="writeToBrowser" source="#expandpath("./rotated.jpg")#">
```

### Image Resize

```cfml
<cfimage action="resize" source="https://avatars1.githubusercontent.com/u/10973141?s=280&v=4"
name="resize" overwrite="true" height="300" width="400" quality="1">
<cfimage action="writeToBrowser" source="#resize#">

```

### Image border

```cfml
<cfimage action="border" source="https://avatars1.githubusercontent.com/u/10973141?s=280&v=4" color="red"
name="withborder">
<cfimage action="writeToBrowser" source="#withborder#">
```

### Script Syntax

### Image write

```cfml
 newImg = imageNew("",200,200,"rgb","blue");
cfimage(action="write", source="#newImg#", name="writeimg", destination="pathname", overwrite="true");
```

### Image Captcha

```cfml
cfimage(action="captcha",text="Captcha!", difficulty="low",height="30",width="150",fontSize="18",
fonts="Comic Sans MS,Times New Roman");
```

### Image Read

```cfml
cfimage(action="read",name="sourceImage",source="https://avatars1.githubusercontent.com/u/10973141?s=280&v=4")
writeDump(sourceImage);
```

### Image Info

```cfml
cfimage(action="info",structname="sourceImage",source="https://avatars1.githubusercontent.com/u/10973141?s=280&v=4")
writeDump(sourceImage);
```

### Image Convert

```cfml
cfimage(action="convert",structname="sourceImage",destination="#expandpath("./lii.jpeg")#",
source="https://avatars1.githubusercontent.com/u/10973141?s=280&v=4" overwrite="true")
cfimage(action="writeToBrowser",source="#expandpath("./lii.jpeg")#")
```

### Image WriteToBrowser

```cfml
cfimage(action="writeToBrowser",source="https://avatars1.githubusercontent.com/u/10973141?s=280&v=4")
```

### Image Rotate

```cfml
cfimage(action="rotate",source="https://avatars1.githubusercontent.com/u/10973141?s=280&v=4",
destination="#expandPath( 'rotated.jpg' )#",overwrite="true",angle="30",quality="1")
cfimage(action="writeToBrowser",source="#expandpath("./rotated.jpg")#")
```

### Image Resize

```cfml
cfimage(action="resize",source="https://avatars1.githubusercontent.com/u/10973141?s=280&v=4",name="resize",
overwrite="true",height="300",width="400",quality="1")
cfimage(action="writeToBrowser",source="#resize#")
```

### Image border

```cfml
cfimage(action="border" source="https://avatars1.githubusercontent.com/u/10973141?s=280&v=4" color="red" name="withborder");
cfimage(action="writeToBrowser" source="#withborder#");

```








# Categories

[Image manipulation](../../categories/image.md)