# <cfhttpparam>

Required for [<cfhttp>](http.md) POST operations, [<cfhttpparam>](httpparam.md) is used to specify the parameters necessary to a cfhttp POST.

This tag **cannot** have a body.
This tag is also supported within [<cfscript>](script.md)

```
<cfhttpparam
    name=string
    type=body|CGI|cookie|file|form|formfield|header|URL|XML
    value=any
    file=string
    encoded=boolean
    mimetype=string
>
```

# Attributes

| Attribute | Type | Required | Description | Default |
|-----------|------|----------|-------------|---------|
| name | string | No | A variable name for the data being passed. |  |
| type | string | No | valid values are: - `header`: specifies an HTTP header. - `CGI`: specifies an HTTP header. Encodes the value depending on the attribute "encoded - `body`: specifies the body of the HTTP request. - `XML`: identifies the request as having a content-type of text/xml. Specifies that the value attribute contains the body of the HTTP request. Used to send XML to the destination URL. - `file`: tells Lucee to send the contents of the specified file. - `URL`: specifies a URL query string name-value pair to append to the cfhttp url attribute. - `form,formField`: specifies a form field to send. - `cookie`: specifies a cookie to send as an HTTP header. | URL |
| value | any | No | Specifies the value of the URL, FormField, Cookie, File, or CGI variable being passed. |  |
| file | string | No | Required for type = `File`. |  |
| encoded | boolean | No | Applies to type `cgi` and `url`, ignored for all other types. Specifies whether to URL encode the values defined with the tag, but only if necessary (no double encoding). |  |
| mimetype | string | No | Applies to File type; invalid for all other types. Specifies the MIME media type of the file contents. The content type can include an identifier for the character encoding of the file; For example, `text/html; charset=ISO-8859-1` indicates that the file is HTML text in the ISO Latin-1 character encoding. |  |

# Examples

### Simple Example

```cfml
 <cfhttpparam name="test_file", type="file", file="filepath/file.ext">
<cfscript>
 //Script format
 cfhttpparam(name="test_file", type="file", file="filepath/file.ext");
</cfscript>
```








# See Also

[<cfhttp>](http.md)